"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_NUMBER_OF_SERVICES = void 0;
exports.getServicesItems = getServicesItems;
var _with_apm_span = require("../../../utils/with_apm_span");
var _get_health_statuses = require("./get_health_statuses");
var _get_services_without_transactions = require("./get_services_without_transactions");
var _get_service_alerts = require("./get_service_alerts");
var _get_service_transaction_stats = require("./get_service_transaction_stats");
var _merge_service_stats = require("./merge_service_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_NUMBER_OF_SERVICES = 1_000;
exports.MAX_NUMBER_OF_SERVICES = MAX_NUMBER_OF_SERVICES;
async function getServicesItems({
  environment,
  kuery,
  mlClient,
  apmEventClient,
  apmAlertsClient,
  logger,
  start,
  end,
  serviceGroup,
  randomSampler,
  documentType,
  rollupInterval
}) {
  return (0, _with_apm_span.withApmSpan)('get_services_items', async () => {
    var _mergeServiceStats;
    const commonParams = {
      environment,
      kuery,
      maxNumServices: MAX_NUMBER_OF_SERVICES,
      start,
      end,
      serviceGroup,
      randomSampler,
      documentType,
      rollupInterval
    };
    const [{
      serviceStats,
      serviceOverflowCount
    }, {
      services: servicesWithoutTransactions,
      maxServiceCountExceeded
    }, healthStatuses, alertCounts] = await Promise.all([(0, _get_service_transaction_stats.getServiceTransactionStats)({
      ...commonParams,
      apmEventClient
    }), (0, _get_services_without_transactions.getServicesWithoutTransactions)({
      ...commonParams,
      apmEventClient
    }), (0, _get_health_statuses.getHealthStatuses)({
      ...commonParams,
      mlClient
    }).catch(err => {
      logger.error(err);
      return [];
    }), (0, _get_service_alerts.getServicesAlerts)({
      ...commonParams,
      apmAlertsClient
    }).catch(err => {
      logger.error(err);
      return [];
    })]);
    return {
      items: (_mergeServiceStats = (0, _merge_service_stats.mergeServiceStats)({
        serviceStats,
        servicesWithoutTransactions,
        healthStatuses,
        alertCounts
      })) !== null && _mergeServiceStats !== void 0 ? _mergeServiceStats : [],
      maxServiceCountExceeded,
      serviceOverflowCount
    };
  });
}