"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNamesFromTermsEnum = getServiceNamesFromTermsEnum;
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../common/environment_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceNamesFromTermsEnum({
  apmEventClient,
  environment,
  maxNumberOfServices
}) {
  if (environment !== _environment_filter_values.ENVIRONMENT_ALL.value) {
    return [];
  }
  const response = await apmEventClient.termsEnum('get_services_from_terms_enum', {
    apm: {
      events: [_common.ProcessorEvent.transaction, _common.ProcessorEvent.span, _common.ProcessorEvent.metric, _common.ProcessorEvent.error]
    },
    size: maxNumberOfServices,
    field: _apm.SERVICE_NAME
  });
  return response.terms;
}