"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceTransactionGroups = getServiceTransactionGroups;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _calculate_throughput = require("../../lib/helpers/calculate_throughput");
var _latency_aggregation_type = require("../../lib/helpers/latency_aggregation_type");
var _transactions = require("../../lib/helpers/transactions");
var _transaction_error_rate = require("../../lib/helpers/transaction_error_rate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const txGroupsDroppedBucketName = '_other';
async function getServiceTransactionGroups({
  environment,
  kuery,
  serviceName,
  apmEventClient,
  transactionType,
  latencyAggregationType,
  start,
  end,
  documentType,
  rollupInterval
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7;
  const field = (0, _transactions.getDurationFieldForTransactions)(documentType);
  const response = await apmEventClient.search('get_service_transaction_groups', {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, {
            bool: {
              should: [{
                term: {
                  [_apm.TRANSACTION_NAME]: txGroupsDroppedBucketName
                }
              }, {
                term: {
                  [_apm.TRANSACTION_TYPE]: transactionType
                }
              }]
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        total_duration: {
          sum: {
            field
          }
        },
        transaction_overflow_count: {
          sum: {
            field: _apm.TRANSACTION_OVERFLOW_COUNT
          }
        },
        transaction_groups: {
          terms: {
            field: _apm.TRANSACTION_NAME,
            size: 1000,
            order: {
              _count: 'desc'
            }
          },
          aggs: {
            transaction_group_total_duration: {
              sum: {
                field
              }
            },
            ...(0, _latency_aggregation_type.getLatencyAggregation)(latencyAggregationType, field),
            ...(0, _transaction_error_rate.getOutcomeAggregation)(documentType)
          }
        }
      }
    }
  });
  const totalDuration = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.total_duration.value;
  const transactionGroups = (_response$aggregation2 = (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.transaction_groups.buckets.map(bucket => {
    const errorRate = (0, _transaction_error_rate.calculateFailedTransactionRate)(bucket);
    const transactionGroupTotalDuration = bucket.transaction_group_total_duration.value || 0;
    return {
      name: bucket.key,
      latency: (0, _latency_aggregation_type.getLatencyValue)({
        latencyAggregationType,
        aggregation: bucket.latency
      }),
      throughput: (0, _calculate_throughput.calculateThroughputWithRange)({
        start,
        end,
        value: bucket.doc_count
      }),
      errorRate,
      impact: totalDuration ? transactionGroupTotalDuration * 100 / totalDuration : 0
    };
  })) !== null && _response$aggregation2 !== void 0 ? _response$aggregation2 : [];
  return {
    transactionGroups: transactionGroups.map(transactionGroup => ({
      ...transactionGroup,
      transactionType
    })),
    maxTransactionGroupsExceeded: ((_response$aggregation4 = (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.transaction_groups.sum_other_doc_count) !== null && _response$aggregation4 !== void 0 ? _response$aggregation4 : 0) > 0,
    transactionOverflowCount: (_response$aggregation6 = (_response$aggregation7 = response.aggregations) === null || _response$aggregation7 === void 0 ? void 0 : _response$aggregation7.transaction_overflow_count.value) !== null && _response$aggregation6 !== void 0 ? _response$aggregation6 : 0
  };
}