"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileMostUsedNCTCharts = getMobileMostUsedNCTCharts;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _merge_other_count = require("./merge_other_count");
var _mobile_types = require("../../../../common/mobile_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileMostUsedNCTCharts({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const MAX_ITEMS_PER_CHART = 5;
  const response = await apmEventClient.search('get_mobile_most_used_nct_charts', {
    apm: {
      events: [_common.ProcessorEvent.span]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        netConnectionTypes: {
          terms: {
            field: _apm.NETWORK_CONNECTION_TYPE,
            size: MAX_ITEMS_PER_CHART
          }
        }
      }
    }
  });
  return {
    key: _mobile_types.MobilePropertyType.NetworkConnectionType,
    options: (0, _merge_other_count.mergeCountWithOther)((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.netConnectionTypes) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.buckets, (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.netConnectionTypes) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.sum_other_doc_count) || []
  };
}