"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileMostUsedCharts = getMobileMostUsedCharts;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _merge_other_count = require("./merge_other_count");
var _mobile_types = require("../../../../common/mobile_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileMostUsedCharts({
  kuery,
  apmEventClient,
  serviceName,
  transactionType,
  environment,
  start,
  end
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9, _response$aggregation10, _response$aggregation11, _response$aggregation12;
  const MAX_ITEMS_PER_CHART = 5;
  const response = await apmEventClient.search('get_mobile_most_used_charts', {
    apm: {
      events: [_common.ProcessorEvent.transaction]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
        }
      },
      aggs: {
        devices: {
          terms: {
            field: _apm.DEVICE_MODEL_IDENTIFIER,
            size: MAX_ITEMS_PER_CHART
          }
        },
        osVersions: {
          terms: {
            field: _apm.HOST_OS_VERSION,
            size: MAX_ITEMS_PER_CHART
          }
        },
        appVersions: {
          terms: {
            field: _apm.SERVICE_VERSION,
            size: MAX_ITEMS_PER_CHART
          }
        }
      }
    }
  });
  return [{
    key: _mobile_types.MobilePropertyType.Device,
    options: (0, _merge_other_count.mergeCountWithOther)((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.devices) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.buckets, (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.devices) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.sum_other_doc_count) || []
  }, {
    key: _mobile_types.MobilePropertyType.OsVersion,
    options: (0, _merge_other_count.mergeCountWithOther)((_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : (_response$aggregation6 = _response$aggregation5.osVersions) === null || _response$aggregation6 === void 0 ? void 0 : _response$aggregation6.buckets, (_response$aggregation7 = response.aggregations) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.osVersions) === null || _response$aggregation8 === void 0 ? void 0 : _response$aggregation8.sum_other_doc_count) || []
  }, {
    key: _mobile_types.MobilePropertyType.AppVersion,
    options: (0, _merge_other_count.mergeCountWithOther)((_response$aggregation9 = response.aggregations) === null || _response$aggregation9 === void 0 ? void 0 : (_response$aggregation10 = _response$aggregation9.appVersions) === null || _response$aggregation10 === void 0 ? void 0 : _response$aggregation10.buckets, (_response$aggregation11 = response.aggregations) === null || _response$aggregation11 === void 0 ? void 0 : (_response$aggregation12 = _response$aggregation11.appVersions) === null || _response$aggregation12 === void 0 ? void 0 : _response$aggregation12.sum_other_doc_count) || []
  }];
}