"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmFleetRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var t = _interopRequireWildcard(require("io-ts"));
var _apm_saved_object_constants = require("../../../common/apm_saved_object_constants");
var _create_internal_es_client = require("../../lib/helpers/create_es_client/create_internal_es_client");
var _get_internal_saved_objects_client = require("../../lib/helpers/get_internal_saved_objects_client");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _create_cloud_apm_package_policy = require("./create_cloud_apm_package_policy");
var _get_agents = require("./get_agents");
var _get_apm_package_policies = require("./get_apm_package_policies");
var _get_java_agent_versions = require("./get_java_agent_versions");
var _get_unsupported_apm_server_schema = require("./get_unsupported_apm_server_schema");
var _is_superuser = require("./is_superuser");
var _run_migration_check = require("./run_migration_check");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasFleetDataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fleet/has_apm_policies',
  options: {
    tags: []
  },
  handler: async ({
    core,
    plugins
  }) => {
    var _plugins$fleet;
    const fleetPluginStart = await ((_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.start());
    if (!fleetPluginStart) {
      return {
        hasApmPolicies: false
      };
    }
    const coreStart = await core.start();
    const packagePolicies = await (0, _get_apm_package_policies.getApmPackagePolicies)({
      coreStart,
      fleetPluginStart
    });
    return {
      hasApmPolicies: packagePolicies.total > 0
    };
  }
});
const fleetAgentsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fleet/agents',
  options: {
    tags: []
  },
  handler: async ({
    core,
    plugins
  }) => {
    var _plugins$cloud, _plugins$fleet2;
    return (0, _get_agents.getFleetAgents)({
      coreStart: await core.start(),
      cloudPluginSetup: (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.setup,
      fleetPluginStart: await ((_plugins$fleet2 = plugins.fleet) === null || _plugins$fleet2 === void 0 ? void 0 : _plugins$fleet2.start())
    });
  }
});
const saveApmServerSchemaRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /api/apm/fleet/apm_server_schema',
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  params: t.type({
    body: t.type({
      schema: t.record(t.string, t.unknown)
    })
  }),
  handler: async resources => {
    const {
      params,
      logger,
      core
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = await (0, _get_internal_saved_objects_client.getInternalSavedObjectsClient)(coreStart);
    const {
      schema
    } = params.body;
    await savedObjectsClient.create(_apm_saved_object_constants.APM_SERVER_SCHEMA_SAVED_OBJECT_TYPE, {
      schemaJson: JSON.stringify(schema)
    }, {
      id: _apm_saved_object_constants.APM_SERVER_SCHEMA_SAVED_OBJECT_ID,
      overwrite: true
    });
    logger.info(`Stored apm-server schema.`);
  }
});
const getUnsupportedApmServerSchemaRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fleet/apm_server_schema/unsupported',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      context
    } = resources;
    const savedObjectsClient = (await context.core).savedObjects.client;
    return {
      unsupported: await (0, _get_unsupported_apm_server_schema.getUnsupportedApmServerSchema)({
        savedObjectsClient
      })
    };
  }
});
const getMigrationCheckRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fleet/migration_check',
  options: {
    tags: ['access:apm']
  },
  handler: async resources => {
    const {
      core,
      plugins,
      context,
      config,
      request
    } = resources;
    const {
      fleet,
      security
    } = plugins;
    if (!fleet || !security) {
      throw _boom.default.internal(FLEET_SECURITY_REQUIRED_MESSAGE);
    }
    return (0, _run_migration_check.runMigrationCheck)({
      core,
      plugins: {
        ...plugins,
        fleet,
        security
      },
      context,
      config,
      request
    });
  }
});
const createCloudApmPackagePolicyRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/fleet/cloud_apm_package_policy',
  options: {
    tags: ['access:apm', 'access:apm_write']
  },
  handler: async resources => {
    var _plugins$cloud2;
    const {
      plugins,
      context,
      config,
      request,
      logger
    } = resources;
    const cloudApmMigrationEnabled = config.agent.migrations.enabled;
    if (!plugins.fleet || !plugins.security) {
      throw _boom.default.internal(FLEET_SECURITY_REQUIRED_MESSAGE);
    }
    const [savedObjectsClient, coreStart, fleetPluginStart, securityPluginStart] = await Promise.all([(await context.core).savedObjects.client, resources.core.start(), plugins.fleet.start(), plugins.security.start()]);
    const esClient = coreStart.elasticsearch.client.asScoped(resources.request).asCurrentUser;
    const cloudPluginSetup = (_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : _plugins$cloud2.setup;
    const hasRequiredRole = (0, _is_superuser.isSuperuser)({
      securityPluginStart,
      request
    });
    if (!hasRequiredRole || !cloudApmMigrationEnabled) {
      throw _boom.default.forbidden(CLOUD_SUPERUSER_REQUIRED_MESSAGE);
    }
    const internalESClient = await (0, _create_internal_es_client.createInternalESClientWithContext)({
      context,
      request,
      debug: resources.params.query._inspect,
      config: resources.config
    });
    const cloudApmPackagePolicy = await (0, _create_cloud_apm_package_policy.createCloudApmPackgePolicy)({
      cloudPluginSetup,
      fleetPluginStart,
      savedObjectsClient,
      esClient,
      logger,
      internalESClient,
      request
    });
    return {
      cloudApmPackagePolicy
    };
  }
});
const javaAgentVersions = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/fleet/java_agent_versions',
  options: {
    tags: []
  },
  handler: async () => {
    const versions = await (0, _get_java_agent_versions.getJavaAgentVersionsFromRegistry)();
    return {
      versions
    };
  }
});
const apmFleetRouteRepository = {
  ...hasFleetDataRoute,
  ...fleetAgentsRoute,
  ...saveApmServerSchemaRoute,
  ...getUnsupportedApmServerSchemaRoute,
  ...getMigrationCheckRoute,
  ...createCloudApmPackagePolicyRoute,
  ...javaAgentVersions
};
exports.apmFleetRouteRepository = apmFleetRouteRepository;
const FLEET_SECURITY_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.apm.api.fleet.fleetSecurityRequired', {
  defaultMessage: `Fleet and Security plugins are required`
});
const CLOUD_SUPERUSER_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.apm.api.fleet.cloud_apm_package_policy.requiredRoleOnCloud', {
  defaultMessage: 'Operation only permitted by Elastic Cloud users with the superuser role.'
});