"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_MAP_PATH = exports.SOURCE_MAP_API_KEY_PATH = exports.AGENT_CONFIG_PATH = exports.AGENT_CONFIG_API_KEY_PATH = void 0;
exports.getPackagePolicyWithAgentConfigurations = getPackagePolicyWithAgentConfigurations;
exports.getPackagePolicyWithApiKeys = getPackagePolicyWithApiKeys;
exports.getPackagePolicyWithSourceMap = getPackagePolicyWithSourceMap;
exports.policyHasApiKey = policyHasApiKey;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// agent config
const AGENT_CONFIG_PATH = `inputs[0].config['apm-server'].value.agent_config`;
exports.AGENT_CONFIG_PATH = AGENT_CONFIG_PATH;
const AGENT_CONFIG_API_KEY_PATH = `inputs[0].config['apm-server'].value.agent.config.elasticsearch.api_key`;

// source map
exports.AGENT_CONFIG_API_KEY_PATH = AGENT_CONFIG_API_KEY_PATH;
const SOURCE_MAP_API_KEY_PATH = `inputs[0].config['apm-server'].value.rum.source_mapping.elasticsearch.api_key`;
exports.SOURCE_MAP_API_KEY_PATH = SOURCE_MAP_API_KEY_PATH;
const SOURCE_MAP_PATH = `inputs[0].config['apm-server'].value.rum.source_mapping.metadata`;

/*
 * Will decorate the package policy with agent configurations
 */
exports.SOURCE_MAP_PATH = SOURCE_MAP_PATH;
function getPackagePolicyWithAgentConfigurations(packagePolicy, agentConfigurations) {
  const packagePolicyClone = (0, _lodash.cloneDeep)(packagePolicy);
  const value = agentConfigurations.map(configuration => ({
    service: configuration.service,
    config: configuration.settings,
    etag: configuration.etag,
    [_apm.AGENT_NAME]: configuration.agent_name
  }));
  (0, _saferLodashSet.set)(packagePolicyClone, AGENT_CONFIG_PATH, value);
  return packagePolicyClone;
}

/*
 * Will decorate the package policy with source maps
 */
function getPackagePolicyWithSourceMap({
  packagePolicy,
  artifacts
}) {
  const packagePolicyClone = (0, _lodash.cloneDeep)(packagePolicy);
  const value = artifacts.map(artifact => ({
    'service.name': artifact.body.serviceName,
    'service.version': artifact.body.serviceVersion,
    'bundle.filepath': artifact.body.bundleFilepath,
    'sourcemap.url': artifact.relative_url
  }));
  (0, _saferLodashSet.set)(packagePolicyClone, SOURCE_MAP_PATH, value);
  return packagePolicyClone;
}

/*
 * Will decorate the package policy with api keys for source maps and agent configurations
 */
function getPackagePolicyWithApiKeys({
  packagePolicy,
  agentConfigApiKey,
  sourceMapApiKey
}) {
  const packagePolicyClone = (0, _lodash.cloneDeep)(packagePolicy);
  (0, _saferLodashSet.set)(packagePolicyClone, SOURCE_MAP_API_KEY_PATH, sourceMapApiKey);
  (0, _saferLodashSet.set)(packagePolicyClone, AGENT_CONFIG_API_KEY_PATH, agentConfigApiKey);
  return packagePolicyClone;
}
function policyHasApiKey(packagePolicy) {
  return (0, _lodash.get)(packagePolicy, AGENT_CONFIG_API_KEY_PATH) !== undefined || (0, _lodash.get)(packagePolicy, SOURCE_MAP_API_KEY_PATH) !== undefined;
}