"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnvironments = getEnvironments;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _transactions = require("../../lib/helpers/transactions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is used for getting the list of environments for the environment selector,
 * filtered by range.
 */
async function getEnvironments({
  searchAggregatedTransactions,
  serviceName,
  apmEventClient,
  size,
  start,
  end
}) {
  const operationName = serviceName ? 'get_environments_for_service' : 'get_environments';
  const params = {
    apm: {
      events: [(0, _transactions.getProcessorEventForTransactions)(searchAggregatedTransactions), _common.ProcessorEvent.metric, _common.ProcessorEvent.error]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName)]
        }
      },
      aggs: {
        environments: {
          terms: {
            field: _apm.SERVICE_ENVIRONMENT,
            missing: _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value,
            size
          }
        }
      }
    }
  };
  const resp = await apmEventClient.search(operationName, params);
  const aggs = resp.aggregations;
  const environmentsBuckets = (aggs === null || aggs === void 0 ? void 0 : aggs.environments.buckets) || [];
  const environments = environmentsBuckets.map(environmentBucket => environmentBucket.key);
  return environments;
}