"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerErrorCountRuleType = registerErrorCountRuleType;
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server = require("@kbn/rule-registry-plugin/server");
var _server2 = require("@kbn/observability-plugin/server");
var _common2 = require("@kbn/spaces-plugin/common");
var _rxjs = require("rxjs");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _apm = require("../../../../../common/es_fields/apm");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _schema = require("../../../../../common/rules/schema");
var _environment_query = require("../../../../../common/utils/environment_query");
var _formatters = require("../../../../../common/utils/formatters");
var _get_apm_indices = require("../../../settings/apm_indices/get_apm_indices");
var _action_variables = require("../../action_variables");
var _alerting_es_client = require("../../alerting_es_client");
var _register_apm_rule_types = require("../../register_apm_rule_types");
var _get_service_group_fields = require("../get_service_group_fields");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _get_groupby_action_variables = require("../utils/get_groupby_action_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeConfig = _apm_rule_types.RULE_TYPES_CONFIG[_apm_rule_types.ApmRuleType.ErrorCount];
function registerErrorCountRuleType({
  alerting,
  basePath,
  config$,
  logger,
  ruleDataClient
}) {
  const createLifecycleRuleType = (0, _server.createLifecycleRuleTypeFactory)({
    ruleDataClient,
    logger
  });
  alerting.registerType(createLifecycleRuleType({
    id: _apm_rule_types.ApmRuleType.ErrorCount,
    name: ruleTypeConfig.name,
    actionGroups: ruleTypeConfig.actionGroups,
    defaultActionGroupId: ruleTypeConfig.defaultActionGroupId,
    validate: {
      params: _schema.errorCountParamsSchema
    },
    actionVariables: {
      context: [_action_variables.apmActionVariables.environment, _action_variables.apmActionVariables.interval, _action_variables.apmActionVariables.reason, _action_variables.apmActionVariables.serviceName, _action_variables.apmActionVariables.transactionName, _action_variables.apmActionVariables.errorGroupingKey, _action_variables.apmActionVariables.threshold, _action_variables.apmActionVariables.triggerValue, _action_variables.apmActionVariables.viewInAppUrl]
    },
    producer: _apm_rule_types.APM_SERVER_FEATURE_ID,
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: async ({
      params: ruleParams,
      services,
      spaceId
    }) => {
      var _ruleParams$groupBy, _response$aggregation, _response$aggregation2;
      const predefinedGroupby = [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT];
      const allGroupbyFields = Array.from(new Set([...predefinedGroupby, ...((_ruleParams$groupBy = ruleParams.groupBy) !== null && _ruleParams$groupBy !== void 0 ? _ruleParams$groupBy : [])]));
      const config = await (0, _rxjs.firstValueFrom)(config$);
      const {
        savedObjectsClient,
        scopedClusterClient
      } = services;
      const indices = await (0, _get_apm_indices.getApmIndices)({
        config,
        savedObjectsClient
      });
      const searchParams = {
        index: indices.error,
        body: {
          track_total_hits: false,
          size: 0,
          query: {
            bool: {
              filter: [{
                range: {
                  '@timestamp': {
                    gte: `now-${ruleParams.windowSize}${ruleParams.windowUnit}`
                  }
                }
              }, {
                term: {
                  [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.error
                }
              }, ...(0, _server2.termQuery)(_apm.SERVICE_NAME, ruleParams.serviceName, {
                queryEmptyString: false
              }), ...(0, _server2.termQuery)(_apm.ERROR_GROUP_ID, ruleParams.errorGroupingKey, {
                queryEmptyString: false
              }), ...(0, _environment_query.environmentQuery)(ruleParams.environment)]
            }
          },
          aggs: {
            error_counts: {
              multi_terms: {
                terms: (0, _get_groupby_terms.getGroupByTerms)(allGroupbyFields),
                size: 1000,
                order: {
                  _count: 'desc'
                }
              },
              aggs: (0, _get_service_group_fields.getServiceGroupFieldsAgg)()
            }
          }
        }
      };
      const response = await (0, _alerting_es_client.alertingEsClient)({
        scopedClusterClient,
        params: searchParams
      });
      const errorCountResults = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.error_counts.buckets.map(bucket => {
        const groupByFields = bucket.key.reduce((obj, bucketKey, bucketIndex) => {
          obj[allGroupbyFields[bucketIndex]] = bucketKey;
          return obj;
        }, {});
        const bucketKey = bucket.key;
        return {
          errorCount: bucket.doc_count,
          sourceFields: (0, _get_service_group_fields.getServiceGroupFields)(bucket),
          groupByFields,
          bucketKey
        };
      })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
      errorCountResults.filter(result => result.errorCount >= ruleParams.threshold).forEach(result => {
        var _getEnvironmentEsFiel;
        const {
          errorCount,
          sourceFields,
          groupByFields,
          bucketKey
        } = result;
        const alertReason = (0, _apm_rule_types.formatErrorCountReason)({
          threshold: ruleParams.threshold,
          measured: errorCount,
          windowSize: ruleParams.windowSize,
          windowUnit: ruleParams.windowUnit,
          groupByFields
        });
        const relativeViewInAppUrl = (0, _formatters.getAlertUrlErrorCount)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel === void 0 ? void 0 : _getEnvironmentEsFiel[_apm.SERVICE_ENVIRONMENT]);
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        services.alertWithLifecycle({
          id: bucketKey.join('_'),
          fields: {
            [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.error,
            [_ruleDataUtils.ALERT_EVALUATION_VALUE]: errorCount,
            [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: ruleParams.threshold,
            [_apm.ERROR_GROUP_ID]: ruleParams.errorGroupingKey,
            [_ruleDataUtils.ALERT_REASON]: alertReason,
            ...sourceFields,
            ...groupByFields
          }
        }).scheduleActions(ruleTypeConfig.defaultActionGroupId, {
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason: alertReason,
          threshold: ruleParams.threshold,
          errorGroupingKey: ruleParams.errorGroupingKey,
          // When group by doesn't include error.grouping_key, the context.error.grouping_key action variable will contain value of the Error Grouping Key filter
          triggerValue: errorCount,
          viewInAppUrl,
          ...groupByActionVariables
        });
      });
      return {
        state: {}
      };
    },
    alerts: _register_apm_rule_types.ApmRuleTypeAlertDefinition
  }));
}