"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAlertsClient = getApmAlertsClient;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmAlertsClient({
  plugins,
  request
}) {
  const ruleRegistryPluginStart = await plugins.ruleRegistry.start();
  const alertsClient = await ruleRegistryPluginStart.getRacClientWithRequest(request);
  const apmAlertsIndices = await alertsClient.getAuthorizedAlertsIndices(['apm']);
  if (!apmAlertsIndices || (0, _lodash.isEmpty)(apmAlertsIndices)) {
    throw Error('No alert indices exist for "apm"');
  }
  return {
    search(searchParams) {
      return alertsClient.find({
        ...searchParams,
        index: apmAlertsIndices.join(',')
      });
    }
  };
}