"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestBase = getRequestBase;
exports.processorEventsToIndex = processorEventsToIndex;
var _common = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
require("../../../../../common/document_type");
var _apm = require("../../../../../common/es_fields/apm");
var _document_type2 = require("../document_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processorEventIndexMap = {
  [_common.ProcessorEvent.transaction]: 'transaction',
  [_common.ProcessorEvent.span]: 'span',
  [_common.ProcessorEvent.metric]: 'metric',
  [_common.ProcessorEvent.error]: 'error'
};
function processorEventsToIndex(events, indices) {
  return (0, _lodash.uniq)(events.flatMap(event => indices[processorEventIndexMap[event]].split(',').map(str => str.trim())));
}
function getRequestBase(options) {
  const events = 'events' in options.apm ? options.apm.events : options.apm.sources.map(source => (0, _document_type2.getProcessorEventForDocumentType)(source.documentType));
  const index = processorEventsToIndex(events, options.indices);
  const filters = [{
    terms: {
      [_apm.PROCESSOR_EVENT]: events
    }
  }];
  if ('sources' in options.apm) {
    options.apm.sources.forEach(source => {
      const {
        getQuery
      } = (0, _document_type2.getConfigForDocumentType)(source.documentType);
      if (getQuery) {
        filters.push(getQuery(source.rollupInterval));
      }
    });
  }
  return {
    index,
    events,
    filters
  };
}