"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorColor = void 0;
exports.httpStatusCodeToColor = httpStatusCodeToColor;
exports.warningColor = exports.successColor = exports.neutralColor = void 0;
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  euiColorDarkShade,
  euiColorWarning
} = _uiTheme.euiLightVars;
const errorColor = '#c23c2b';
exports.errorColor = errorColor;
const neutralColor = euiColorDarkShade;
exports.neutralColor = neutralColor;
const successColor = '#327a42';
exports.successColor = successColor;
const warningColor = euiColorWarning;
exports.warningColor = warningColor;
const httpStatusCodeColors = {
  1: neutralColor,
  2: successColor,
  3: neutralColor,
  4: warningColor,
  5: errorColor
};
function getStatusColor(status) {
  return httpStatusCodeColors[status.toString().substr(0, 1)];
}

/**
 * Convert an HTTP status code to a color.
 *
 * If passed a string, it will remove all non-numeric characters
 */
function httpStatusCodeToColor(status) {
  if (typeof status === 'string') {
    return getStatusColor(parseInt(status.replace(/\D/g, ''), 10));
  } else {
    return getStatusColor(status);
  }
}