"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _agent_config_instructions = require("./agent_config_instructions");
var _get_policy_options = require("./get_policy_options");
var _policy_selector = require("./policy_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CentralizedContainer = _styledComponents.default.div`
  display: flex;
  justify-content: center;
  align-items: center;
`;
const MANAGE_FLEET_POLICIES_LABEL = _i18n.i18n.translate('xpack.apm.tutorial.agent_config.manageFleetPolicies', {
  defaultMessage: 'Manage fleet policies'
});
const GET_STARTED_WITH_FLEET_LABEL = _i18n.i18n.translate('xpack.apm.tutorial.agent_config.getStartedWithFleet', {
  defaultMessage: 'Get started with fleet'
});
const INITIAL_STATE = {
  fleetAgents: [],
  cloudStandaloneSetup: undefined,
  isFleetEnabled: false
};
function getFleetLink({
  isFleetEnabled,
  hasFleetAgents,
  basePath,
  kibanaVersion
}) {
  if (!isFleetEnabled) {
    return;
  }
  return hasFleetAgents ? {
    label: MANAGE_FLEET_POLICIES_LABEL,
    href: `${basePath}/app/fleet#/policies`
  } : {
    label: GET_STARTED_WITH_FLEET_LABEL,
    href: `${basePath}/app/integrations#/detail/apm/overview`
  };
}
function TutorialConfigAgent({
  variantId,
  http,
  basePath,
  isCloudEnabled,
  kibanaVersion
}) {
  const [data, setData] = (0, _react.useState)(INITIAL_STATE);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [selectedOption, setSelectedOption] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchData() {
      setIsLoading(true);
      try {
        const response = await http.get('/internal/apm/fleet/agents');
        if (response) {
          setData(response);
        }
      } catch (e) {
        setIsLoading(false);
        console.error('Error while fetching fleet agents.', e);
      }
    }
    fetchData();
  }, [http]);

  // Depending the environment running (onPrem/Cloud) different values must be available and automatically selected
  const options = (0, _react.useMemo)(() => {
    const availableOptions = (0, _get_policy_options.getPolicyOptions)({
      isCloudEnabled,
      data
    });
    const defaultSelectedOption = availableOptions.find(({
      isSelected
    }) => isSelected);
    setSelectedOption(defaultSelectedOption);
    setIsLoading(false);
    return availableOptions;
  }, [data, isCloudEnabled]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
      "data-test-subj": "loading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
  }
  const hasFleetAgents = !!data.fleetAgents.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_selector.PolicySelector, {
    options: options,
    selectedOption: selectedOption,
    onChange: newSelectedOption => setSelectedOption(newSelectedOption),
    fleetLink: getFleetLink({
      isFleetEnabled: data.isFleetEnabled,
      hasFleetAgents,
      basePath,
      kibanaVersion
    })
  }), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
    variantId: variantId,
    apmServerUrl: selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.apmServerUrl,
    secretToken: selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.secretToken
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = TutorialConfigAgent;
exports.default = _default;
module.exports = exports.default;