"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPolicyOptions = getPolicyOptions;
var _i18n = require("@kbn/i18n");
var _fleet = require("../../../common/fleet");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STANDALONE_CONFIG_LABEL = _i18n.i18n.translate('xpack.apm.tutorial.agent_config.defaultStandaloneConfig', {
  defaultMessage: 'Default Standalone configuration'
});
function getPolicyOptions({
  isCloudEnabled,
  data
}) {
  var _data$cloudStandalone, _data$cloudStandalone2, _data$cloudStandalone3;
  const isCloudVisible = !!(isCloudEnabled && (_data$cloudStandalone = data.cloudStandaloneSetup) !== null && _data$cloudStandalone !== void 0 && _data$cloudStandalone.apmServerUrl);
  const fleetAgentsOptions = data.fleetAgents.map(agent => {
    return {
      key: agent.id,
      type: 'fleetAgents',
      label: agent.name,
      apmServerUrl: agent.apmServerUrl,
      secretToken: agent.secretToken,
      isVisible: true,
      isSelected: agent.id === _fleet.POLICY_ELASTIC_AGENT_ON_CLOUD
    };
  });
  const hasFleetAgentsSelected = fleetAgentsOptions.some(({
    isSelected
  }) => isSelected);
  return [{
    key: 'cloud',
    type: 'standalone',
    label: DEFAULT_STANDALONE_CONFIG_LABEL,
    apmServerUrl: (_data$cloudStandalone2 = data.cloudStandaloneSetup) === null || _data$cloudStandalone2 === void 0 ? void 0 : _data$cloudStandalone2.apmServerUrl,
    secretToken: (_data$cloudStandalone3 = data.cloudStandaloneSetup) === null || _data$cloudStandalone3 === void 0 ? void 0 : _data$cloudStandalone3.secretToken,
    isVisible: isCloudVisible && !hasFleetAgentsSelected,
    isSelected: !hasFleetAgentsSelected
  }, {
    key: 'onPrem',
    type: 'standalone',
    label: DEFAULT_STANDALONE_CONFIG_LABEL,
    apmServerUrl: 'http://localhost:8200',
    secretToken: '',
    isVisible: !isCloudVisible && !hasFleetAgentsSelected,
    isSelected: !hasFleetAgentsSelected
  }, ...fleetAgentsOptions].filter(({
    isVisible
  }) => isVisible);
}