"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.railsVariables = exports.railsLineNumbers = exports.railsHighlightLang = exports.rails = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const railsVariables = {
  apmServiceName: 'service_name',
  secretToken: 'secret_token',
  apmServerUrl: 'server_url',
  apmEnvironment: 'environment'
};
exports.railsVariables = railsVariables;
const railsHighlightLang = 'rb';
exports.railsHighlightLang = railsHighlightLang;
const railsServiceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.railsClient.createConfig.commands.defaultServiceName', {
  defaultMessage: 'Defaults to the name of your Rails app.'
});
const railsLineNumbers = {
  start: 1,
  highlight: '3, 5, 7, 9',
  annotations: {
    3: `${_shared_hints.serviceNameHint} ${railsServiceNameHint}`,
    5: _shared_hints.secretTokenHint,
    7: _shared_hints.serverUrlHint,
    9: _shared_hints.serviceEnvironmentHint
  }
};
exports.railsLineNumbers = railsLineNumbers;
const rails = `# config/elastic_apm.yml:

${railsVariables.apmServiceName}: '{{{apmServiceName}}}'

${railsVariables.secretToken}: '{{{secretToken}}}'

${railsVariables.apmServerUrl}: '{{{apmServerUrl}}}'

${railsVariables.apmEnvironment}: '{{{apmEnvironment}}}'`;
exports.rails = rails;