"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeVariables = exports.nodeLineNumbers = exports.nodeHighlightLang = exports.node = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeVariables = {
  apmServiceName: 'serviceName',
  secretToken: 'secretToken',
  apmServerUrl: 'serverUrl',
  apmEnvironment: 'environment'
};
exports.nodeVariables = nodeVariables;
const nodeHighlightLang = 'js';
exports.nodeHighlightLang = nodeHighlightLang;
const nodeServiceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.nodeClient.createConfig.commands.serviceName', {
  defaultMessage: 'Overrides the service name in package.json.'
});
const nodeLineNumbers = {
  start: 1,
  highlight: '3, 5, 7, 9',
  annotations: {
    3: `${_shared_hints.serviceNameHint} ${nodeServiceNameHint}`,
    5: _shared_hints.secretTokenHint,
    7: _shared_hints.serverUrlHint,
    9: _shared_hints.serviceEnvironmentHint
  }
};
exports.nodeLineNumbers = nodeLineNumbers;
const node = `// ${_i18n.i18n.translate('xpack.apm.tutorial.nodeClient.configure.commands.addThisToTheFileTopComment', {
  defaultMessage: 'Add this to the very top of the first file loaded in your app'
})}
var apm = require('elastic-apm-node').start({
  ${nodeVariables.apmServiceName}: '{{{apmServiceName}}}',

  ${nodeVariables.secretToken}: '{{{secretToken}}}',

  ${nodeVariables.apmServerUrl}: '{{{apmServerUrl}}}',

  ${nodeVariables.apmEnvironment}: '{{{apmEnvironment}}}'
})`;
exports.node = node;