"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockApmApiCallResponse = exports.getCreateCallApmApiSpy = exports.getCallApmApiSpy = void 0;
var _lodash = require("lodash");
var createCallApmApi = _interopRequireWildcard(require("./create_call_apm_api"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreateCallApmApiSpy = () => jest.spyOn(createCallApmApi, 'createCallApmApi');
exports.getCreateCallApmApiSpy = getCreateCallApmApiSpy;
const getCallApmApiSpy = () => jest.spyOn(createCallApmApi, 'callApmApi');
exports.getCallApmApiSpy = getCallApmApiSpy;
const getSpy = (0, _lodash.once)(() => {
  const spy = getCallApmApiSpy();
  const cache = {};
  const response = (endpoint, fn) => {
    cache[endpoint] = fn;
  };
  spy.mockImplementation((endpoint, params) => {
    const fn = cache[endpoint];
    if (fn) {
      return Promise.resolve(fn(params));
    }
    throw new Error('No cached response defined for ' + endpoint);
  });
  return {
    response
  };
});
const mockApmApiCallResponse = (...args) => {
  getSpy().response(...args);
};
exports.mockApmApiCallResponse = mockApmApiCallResponse;