"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _register_apm_rule_types = require("./components/alerting/rule_types/register_apm_rule_types");
var _fleet_integration = require("./components/fleet_integration");
var _lazy_apm_agents_tab_extension = require("./components/fleet_integration/lazy_apm_agents_tab_extension");
var _lazy_apm_policy_create_extension = require("./components/fleet_integration/lazy_apm_policy_create_extension");
var _lazy_apm_policy_edit_extension = require("./components/fleet_integration/lazy_apm_policy_edit_extension");
var _feature_catalogue_entry = require("./feature_catalogue_entry");
var _service_detail_locator = require("./locator/service_detail_locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const servicesTitle = _i18n.i18n.translate('xpack.apm.navigation.servicesTitle', {
  defaultMessage: 'Services'
});
const serviceGroupsTitle = _i18n.i18n.translate('xpack.apm.navigation.serviceGroupsTitle', {
  defaultMessage: 'Service groups'
});
const tracesTitle = _i18n.i18n.translate('xpack.apm.navigation.tracesTitle', {
  defaultMessage: 'Traces'
});
const serviceMapTitle = _i18n.i18n.translate('xpack.apm.navigation.serviceMapTitle', {
  defaultMessage: 'Service Map'
});
const dependenciesTitle = _i18n.i18n.translate('xpack.apm.navigation.dependenciesTitle', {
  defaultMessage: 'Dependencies'
});
const apmSettingsTitle = _i18n.i18n.translate('xpack.apm.navigation.apmSettingsTitle', {
  defaultMessage: 'Settings'
});
const apmStorageExplorerTitle = _i18n.i18n.translate('xpack.apm.navigation.apmStorageExplorerTitle', {
  defaultMessage: 'Storage Explorer'
});
class ApmPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    var _pluginSetupDeps$home, _pluginSetupDeps$home2, _pluginSetupDeps$home3, _pluginSetupDeps$home4;
    const config = this.initializerContext.config.get();
    const pluginSetupDeps = plugins;
    if (pluginSetupDeps.home) {
      pluginSetupDeps.home.environment.update({
        apmUi: true
      });
      pluginSetupDeps.home.featureCatalogue.register(_feature_catalogue_entry.featureCatalogueEntry);
    }

    // register observability nav if user has access to plugin
    plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.map)(([coreStart, pluginsStart]) => {
      if (coreStart.application.capabilities.apm.show) {
        return [
        // APM navigation
        {
          label: 'APM',
          sortKey: 400,
          entries: [{
            label: servicesTitle,
            app: 'apm',
            path: '/services',
            matchPath(currentPath) {
              return ['/service-groups', '/mobile-services', '/services', '/service-map'].some(testPath => currentPath.startsWith(testPath));
            }
          }, {
            label: tracesTitle,
            app: 'apm',
            path: '/traces'
          }, {
            label: dependenciesTitle,
            app: 'apm',
            path: '/dependencies/inventory',
            onClick: () => {
              const {
                usageCollection
              } = pluginsStart;
              if (usageCollection) {
                usageCollection.reportUiCounter('apm', _public2.METRIC_TYPE.CLICK, 'side_nav_dependency');
              }
            }
          }]
        }];
      }
      return [];
    })));
    const getApmDataHelper = async () => {
      const {
        fetchObservabilityOverviewPageData,
        getHasData
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/apm_observability_overview_fetchers')));
      const {
        hasFleetApmIntegrations
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/tutorial_apm_fleet_check')));
      const {
        createCallApmApi
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/create_call_apm_api')));

      // have to do this here as well in case app isn't mounted yet
      createCallApmApi(core);
      return {
        fetchObservabilityOverviewPageData,
        getHasData,
        hasFleetApmIntegrations
      };
    };

    // Registers a status check callback for the tutorial to call and verify if the APM integration is installed on fleet.
    (_pluginSetupDeps$home = pluginSetupDeps.home) === null || _pluginSetupDeps$home === void 0 ? void 0 : _pluginSetupDeps$home.tutorials.registerCustomStatusCheck('apm_fleet_server_status_check', async () => {
      const {
        hasFleetApmIntegrations
      } = await getApmDataHelper();
      return hasFleetApmIntegrations();
    });

    // Registers custom component that is going to be render on fleet section
    (_pluginSetupDeps$home2 = pluginSetupDeps.home) === null || _pluginSetupDeps$home2 === void 0 ? void 0 : _pluginSetupDeps$home2.tutorials.registerCustomComponent('TutorialFleetInstructions', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/tutorial_fleet_instructions'))));
    (_pluginSetupDeps$home3 = pluginSetupDeps.home) === null || _pluginSetupDeps$home3 === void 0 ? void 0 : _pluginSetupDeps$home3.tutorials.registerCustomComponent('TutorialConfigAgent', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/config_agent'))));
    (_pluginSetupDeps$home4 = pluginSetupDeps.home) === null || _pluginSetupDeps$home4 === void 0 ? void 0 : _pluginSetupDeps$home4.tutorials.registerCustomComponent('TutorialConfigAgentRumScript', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/config_agent/rum_script'))));
    pluginSetupDeps.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.ApmTransactionContextMenu
    });
    pluginSetupDeps.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.ApmErrorContextMenu
    });
    plugins.observability.dashboard.register({
      appName: 'apm',
      hasData: async () => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.getHasData();
      },
      fetchData: async params => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.fetchObservabilityOverviewPageData(params);
      }
    });
    plugins.exploratoryView.register({
      appName: 'apm',
      hasData: async () => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.getHasData();
      },
      fetchData: async params => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.fetchObservabilityOverviewPageData(params);
      }
    });
    const {
      observabilityRuleTypeRegistry
    } = plugins.observability;
    core.application.register({
      id: 'apm',
      title: 'APM',
      order: 8300,
      euiIconType: 'logoObservability',
      appRoute: '/app/apm',
      icon: 'plugins/apm/public/icon.svg',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      deepLinks: [{
        id: 'service-groups-list',
        title: serviceGroupsTitle,
        path: '/service-groups'
      }, {
        id: 'services',
        title: servicesTitle,
        path: '/services'
      }, {
        id: 'traces',
        title: tracesTitle,
        path: '/traces'
      }, {
        id: 'service-map',
        title: serviceMapTitle,
        path: '/service-map'
      }, {
        id: 'dependencies',
        title: dependenciesTitle,
        path: '/dependencies/inventory'
      }, {
        id: 'settings',
        title: apmSettingsTitle,
        path: '/settings'
      }, {
        id: 'storage-explorer',
        title: apmStorageExplorerTitle,
        path: '/storage-explorer'
      }],
      async mount(appMountParameters) {
        // Load application bundle and Get start services
        const [{
          renderApp
        }, [coreStart, pluginsStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), core.getStartServices()]);
        return renderApp({
          coreStart,
          pluginsSetup: pluginSetupDeps,
          appMountParameters,
          config,
          pluginsStart: pluginsStart,
          observabilityRuleTypeRegistry
        });
      }
    });
    (0, _register_apm_rule_types.registerApmRuleTypes)(observabilityRuleTypeRegistry);
    const locator = plugins.share.url.locators.create(new _service_detail_locator.APMServiceDetailLocator(core.uiSettings));
    return {
      locator
    };
  }
  start(core, plugins) {
    const {
      fleet
    } = plugins;
    if (fleet) {
      const agentEnrollmentExtensionData = (0, _fleet_integration.getApmEnrollmentFlyoutData)();
      fleet.registerExtension({
        package: 'apm',
        view: 'agent-enrollment-flyout',
        title: agentEnrollmentExtensionData.title,
        Component: agentEnrollmentExtensionData.Component
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-detail-assets',
        Component: _fleet_integration.LazyApmCustomAssetsExtension
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-create',
        Component: (0, _lazy_apm_policy_create_extension.getLazyAPMPolicyCreateExtension)()
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-edit',
        useLatestPackageVersion: true,
        Component: (0, _lazy_apm_policy_edit_extension.getLazyAPMPolicyEditExtension)()
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-edit-tabs',
        tabs: [{
          title: 'APM Agents',
          Component: (0, _lazy_apm_agents_tab_extension.getLazyApmAgentsTabExtension)()
        }]
      });
    }
  }
}
exports.ApmPlugin = ApmPlugin;