"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTraceExplorerSamples = exports.TraceExplorerSamplesFetcherContextProvider = void 0;
var _react = require("react");
var _create_shared_use_fetcher = require("./create_shared_use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sharedUseFetcher = (0, _create_shared_use_fetcher.createSharedUseFetcher)('GET /internal/apm/traces/find');
const useTraceExplorerSamples = () => {
  const result = sharedUseFetcher.useFetcherResult();
  return (0, _react.useMemo)(() => {
    return {
      ...result,
      data: result.data || {
        traceSamples: []
      }
    };
  }, [result]);
};
exports.useTraceExplorerSamples = useTraceExplorerSamples;
const TraceExplorerSamplesFetcherContextProvider = sharedUseFetcher.Provider;
exports.TraceExplorerSamplesFetcherContextProvider = TraceExplorerSamplesFetcherContextProvider;