"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFallbackToTransactionsFetcher = useFallbackToTransactionsFetcher;
var _get_kuery_with_mobile_filters = require("../../common/utils/get_kuery_with_mobile_filters");
var _use_apm_params = require("./use_apm_params");
var _use_fetcher = require("./use_fetcher");
var _use_time_range = require("./use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFallbackToTransactionsFetcher({
  kuery
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const rangeFrom = 'rangeFrom' in query ? query.rangeFrom : undefined;
  const rangeTo = 'rangeTo' in query ? query.rangeTo : undefined;
  const device = 'device' in query ? query.device : undefined;
  const osVersion = 'osVersion' in query ? query.osVersion : undefined;
  const appVersion = 'appVersion' in query ? query.appVersion : undefined;
  const netConnectionType = 'netConnectionType' in query ? query.netConnectionType : undefined;
  const kueryWithFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo,
    optional: true
  });
  const {
    data = {
      fallbackToTransactions: false
    }
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/fallback_to_transactions', {
      params: {
        query: {
          kuery: kueryWithFilters,
          start,
          end
        }
      }
    });
  }, [kueryWithFilters, start, end]);
  return data;
}