"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApmDataView = useApmDataView;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmDataViewTitle() {
  const res = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/data_view/title', {
    signal: null
  });
  return res.apmDataViewTitle;
}
function useApmDataView() {
  const {
    services,
    notifications
  } = (0, _public.useKibana)();
  const [dataView, setDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchDataView() {
      const title = await getApmDataViewTitle();
      try {
        const displayError = false;
        return await services.dataViews.create({
          title
        }, undefined, displayError);
      } catch (e) {
        const noDataScreen = e.message.includes('No matching indices found');
        if (noDataScreen) {
          return;
        }
        notifications.toasts.danger({
          title: _i18n.i18n.translate('xpack.apm.data_view.creation_failed', {
            defaultMessage: 'An error occurred while creating the data view'
          }),
          body: e.message
        });
        throw e;
      }
    }
    fetchDataView().then(setDataView);
  }, [notifications.toasts, services.dataViews]);
  return {
    dataView
  };
}