"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockTimeRangeContextProvider = MockTimeRangeContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _document_type = require("../../../common/document_type");
var _rollup = require("../../../common/rollup");
var _call_apm_api_spy = require("../../services/rest/call_apm_api_spy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULTS = {
  isUsingServiceDestinationMetrics: true,
  sources: [{
    documentType: _document_type.ApmDocumentType.ServiceTransactionMetric,
    hasDocs: true,
    rollupInterval: _rollup.RollupInterval.OneMinute
  }, {
    documentType: _document_type.ApmDocumentType.TransactionMetric,
    hasDocs: true,
    rollupInterval: _rollup.RollupInterval.OneMinute
  }, {
    documentType: _document_type.ApmDocumentType.TransactionEvent,
    hasDocs: true,
    rollupInterval: _rollup.RollupInterval.None
  }, {
    documentType: _document_type.ApmDocumentType.ServiceDestinationMetric,
    hasDocs: true,
    rollupInterval: _rollup.RollupInterval.None
  }]
};
function MockTimeRangeContextProvider({
  children,
  metadata
}) {
  (0, _react.useMemo)(() => {
    (0, _call_apm_api_spy.mockApmApiCallResponse)('GET /internal/apm/time_range_metadata', () => {
      return metadata !== null && metadata !== void 0 ? metadata : DEFAULTS;
    });
  }, [metadata]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
}