"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidLicenseNotification = InvalidLicenseNotification;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana_url = require("../../hooks/use_kibana_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvalidLicenseNotification() {
  const manageLicenseURL = (0, _use_kibana_url.useKibanaUrl)('/app/management/stack/license_management');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.apm.invalidLicense.title', {
      defaultMessage: 'Invalid License'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.invalidLicense.message', {
      defaultMessage: 'The APM UI is not available because your current license has expired or is no longer valid.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmInvalidLicenseNotificationManageYourLicenseButton",
      href: manageLicenseURL
    }, _i18n.i18n.translate('xpack.apm.invalidLicense.licenseManagementLink', {
      defaultMessage: 'Manage your license'
    }))]
  });
}