"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumb = useBreadcrumb;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = require("react");
var _lodash = require("lodash");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBreadcrumb(callback, fnDeps) {
  const api = (0, _react.useContext)(_context.BreadcrumbsContext);
  if (!api) {
    throw new Error('Missing Breadcrumb API in context');
  }
  const {
    match
  } = (0, _typedReactRouterConfig.useCurrentRoute)();
  const matchedRoute = (0, _react.useRef)(match === null || match === void 0 ? void 0 : match.route);
  (0, _react.useEffect)(() => {
    if (matchedRoute.current && matchedRoute.current !== (match === null || match === void 0 ? void 0 : match.route)) {
      api.unset(matchedRoute.current);
    }
    matchedRoute.current = match === null || match === void 0 ? void 0 : match.route;
    if (matchedRoute.current) {
      api.set(matchedRoute.current, (0, _lodash.castArray)(callback()));
    }
    return () => {
      if (matchedRoute.current) {
        api.unset(matchedRoute.current);
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [match, ...fnDeps]);
}