"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceAgentFetcher = useServiceAgentFetcher;
var _use_fetcher = require("../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = {
  agentName: undefined,
  runtimeName: undefined,
  serverlessType: undefined
};
function useServiceAgentFetcher({
  serviceName,
  start,
  end
}) {
  const {
    data = INITIAL_STATE,
    error,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName) {
      return callApmApi('GET /internal/apm/services/{serviceName}/agent', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [serviceName, start, end]);
  return {
    ...data,
    status,
    error
  };
}