"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsContext = void 0;
exports.AnnotationsContextProvider = AnnotationsContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../hooks/use_fetcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnnotationsContext = /*#__PURE__*/(0, _react.createContext)({
  annotations: []
});
exports.AnnotationsContext = AnnotationsContext;
const INITIAL_STATE = {
  annotations: []
};
function AnnotationsContextProvider({
  children,
  serviceName,
  environment,
  start,
  end
}) {
  const {
    data = INITIAL_STATE
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && serviceName) {
      return callApmApi('GET /api/apm/services/{serviceName}/annotation/search', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            start,
            end
          }
        }
      });
    }
  }, [environment, start, end, serviceName]);
  return /*#__PURE__*/_react.default.createElement(AnnotationsContext.Provider, {
    value: data,
    children: children
  });
}