"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_REFRESH_INTERVAL = void 0;
exports.UnifiedSearchBar = UnifiedSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _reactRouterDom = require("react-router-dom");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _queryString = _interopRequireDefault(require("query-string"));
var _common = require("@kbn/data-plugin/common");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_data_view = require("../../../hooks/use_apm_data_view");
var _use_processor_event = require("../../../hooks/use_processor_event");
var _url_helpers = require("../links/url_helpers");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _get_bool_filter = require("../get_bool_filter");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _call_api = require("../../../services/rest/call_api");
var _use_time_range_id = require("../../../context/time_range_id/use_time_range_id");
var _helpers = require("../../../context/url_params_context/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_REFRESH_INTERVAL = 60000;
exports.DEFAULT_REFRESH_INTERVAL = DEFAULT_REFRESH_INTERVAL;
function useSearchBarParams(defaultKuery) {
  const {
    path,
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const urlKuery = 'kuery' in query ? query.kuery : undefined;
  const serviceName = 'serviceName' in path ? path.serviceName : undefined;
  const groupId = 'groupId' in path ? path.groupId : undefined;
  const environment = 'environment' in query ? query.environment : undefined;
  const refreshIntervalFromUrl = 'refreshInterval' in query ? (0, _helpers.toNumber)(query.refreshInterval) : DEFAULT_REFRESH_INTERVAL;
  const refreshPausedFromUrl = 'refreshPaused' in query ? query.refreshPaused : 'true';
  return {
    kuery: urlKuery ? {
      query: defaultKuery || urlKuery,
      language: 'kuery'
    } : undefined,
    serviceName,
    groupId,
    environment,
    refreshPausedFromUrl,
    refreshIntervalFromUrl
  };
}
function useUrlTimeRange(defaultTimeRange) {
  const location = (0, _reactRouterDom.useLocation)();
  const query = _queryString.default.parse(location.search);
  const isDateRangeSet = 'rangeFrom' in query && 'rangeTo' in query;
  if (isDateRangeSet) {
    return {
      from: query.rangeFrom,
      to: query.rangeTo
    };
  }
  return defaultTimeRange;
}
function getSearchBarPlaceholder(searchbarPlaceholder, processorEvent) {
  const examples = {
    transaction: 'transaction.duration.us > 300000',
    error: 'http.response.status_code >= 400',
    metric: 'process.pid = "1234"',
    defaults: 'transaction.duration.us > 300000 AND http.response.status_code >= 400'
  };
  const example = examples[processorEvent || 'defaults'];
  return searchbarPlaceholder !== null && searchbarPlaceholder !== void 0 ? searchbarPlaceholder : _i18n.i18n.translate('xpack.apm.unifiedSearchBar.placeholder', {
    defaultMessage: `Search {event, select,
            transaction {transactions}
            metric {metrics}
            error {errors}
            other {transactions, errors and metrics}
          } (E.g. {queryExample})`,
    values: {
      queryExample: example,
      event: processorEvent
    }
  });
}
function convertKueryToEsQuery(kuery, dataView) {
  const ast = (0, _esQuery.fromKueryExpression)(kuery);
  return (0, _esQuery.toElasticsearchQuery)(ast, dataView);
}
function UnifiedSearchBar({
  placeholder,
  value,
  showDatePicker = true,
  showSubmitButton = true,
  isClearable = true,
  boolFilter
}) {
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    },
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    data: {
      query: {
        queryString: queryStringService,
        timefilter: timeFilterService
      }
    }
  } = services;
  const {
    kuery,
    serviceName,
    environment,
    groupId,
    refreshPausedFromUrl,
    refreshIntervalFromUrl
  } = useSearchBarParams(value);
  const timePickerTimeDefaults = core.uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
  const urlTimeRange = useUrlTimeRange(timePickerTimeDefaults);
  const [displaySearchBar, setDisplaySearchBar] = (0, _react.useState)(false);
  const syncSearchBarWithUrl = (0, _react.useCallback)(() => {
    // Sync Kuery params with Search Bar
    if (kuery && !(0, _fastDeepEqual.default)(queryStringService.getQuery(), kuery)) {
      queryStringService.setQuery(kuery);
    }
    // On page navigation the search bar persists the state where as the url is cleared, hence we need to clear the search bar
    if (!kuery) {
      queryStringService.clearQuery();
    }
    // Sync Time Range with Search Bar
    timeFilterService.timefilter.setTime(urlTimeRange);

    // Sync Auto refresh interval with Search Bar
    const refreshInterval = {
      pause: (0, _helpers.toBoolean)(refreshPausedFromUrl),
      value: refreshIntervalFromUrl
    };
    timeFilterService.timefilter.setRefreshInterval(refreshInterval);
  }, [kuery, queryStringService, refreshIntervalFromUrl, refreshPausedFromUrl, timeFilterService.timefilter, urlTimeRange]);
  (0, _react.useEffect)(() => {
    syncSearchBarWithUrl();
  }, [syncSearchBarWithUrl]);
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    dataView
  } = (0, _use_apm_data_view.useApmDataView)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const processorEvent = (0, _use_processor_event.useProcessorEvent)();
  const {
    incrementTimeRangeId
  } = (0, _use_time_range_id.useTimeRangeId)();
  const searchbarPlaceholder = getSearchBarPlaceholder(placeholder, processorEvent);
  (0, _react.useEffect)(() => {
    if (dataView) setDisplaySearchBar(true);
  }, [dataView]);
  const customFilters = boolFilter !== null && boolFilter !== void 0 ? boolFilter : (0, _get_bool_filter.getBoolFilter)({
    groupId,
    processorEvent,
    serviceName,
    environment,
    urlParams
  });
  const filtersForSearchBarSuggestions = customFilters.map(filter => {
    return {
      query: filter
    };
  });
  const onRefresh = () => {
    (0, _call_api.clearCache)();
    incrementTimeRangeId();
  };
  const onRefreshChange = ({
    isPaused,
    refreshInterval
  }) => {
    const existingQueryParams = (0, _url_helpers.toQuery)(location.search);
    const updatedQueryParams = {
      ...existingQueryParams,
      refreshPaused: isPaused,
      refreshInterval
    };
    history.push({
      ...location,
      search: (0, _url_helpers.fromQuery)(updatedQueryParams)
    });
  };
  const handleSubmit = (payload, isUpdate) => {
    if (dataView == null) {
      return;
    }
    const {
      dateRange,
      query
    } = payload;
    const {
      from: rangeFrom,
      to: rangeTo
    } = dateRange;
    try {
      const res = convertKueryToEsQuery(query === null || query === void 0 ? void 0 : query.query, dataView);
      if (!res) {
        return;
      }
      const existingQueryParams = (0, _url_helpers.toQuery)(location.search);
      const updatedQueryWithTime = {
        ...existingQueryParams,
        rangeFrom,
        rangeTo
      };
      const newSearchParams = {
        ...updatedQueryWithTime,
        kuery: query === null || query === void 0 ? void 0 : query.query
      };
      if (isUpdate) {
        history.push({
          ...location,
          search: (0, _url_helpers.fromQuery)(newSearchParams)
        });
      } else {
        onRefresh();
      }
    } catch (e) {
      console.log('Invalid kuery syntax'); // eslint-disable-line no-console
    }
  };

  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: !displaySearchBar,
    width: "100%",
    height: "40px"
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _i18n.i18n.translate('xpack.apm.appName', {
      defaultMessage: 'APM'
    }),
    iconType: "search",
    placeholder: searchbarPlaceholder,
    useDefaultBehaviors: true,
    indexPatterns: dataView ? [dataView] : undefined,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: false,
    showDatePicker: showDatePicker,
    showSubmitButton: showSubmitButton,
    displayStyle: "inPage",
    onQuerySubmit: handleSubmit,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    isClearable: isClearable,
    dataTestSubj: "apmUnifiedSearchBar",
    filtersForSuggestions: filtersForSearchBarSuggestions
  }));
}