"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkList = CustomLinkList;
var _mustache = _interopRequireDefault(require("mustache"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _style = require("../../../../utils/style");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomLinkList({
  customLinks,
  transaction
}) {
  return /*#__PURE__*/_react.default.createElement(_public.SectionLinks, {
    style: {
      maxHeight: _style.unit * 10,
      overflowY: 'auto'
    }
  }, customLinks.map(link => {
    const href = getHref(link, transaction);
    return /*#__PURE__*/_react.default.createElement(_public.SectionLink, {
      key: link.id,
      label: link.label,
      href: href,
      target: "_blank"
    });
  }));
}
function getHref(link, transaction) {
  try {
    return _mustache.default.render(link.url, transaction);
  } catch (e) {
    return link.url;
  }
}