"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAgentSummaryItem = UserAgentSummaryItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Version = (0, _common.euiStyled)('span')`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeS};
`;
function UserAgentSummaryItem({
  name,
  version
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.transactionDetails.userAgentAndVersionLabel', {
      defaultMessage: 'User agent & version'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name, "\xA0", version && /*#__PURE__*/_react.default.createElement(Version, null, "(", version, ")")));
}