"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionsSelect = SuggestionsSelect;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SuggestionsSelect({
  customOptions,
  customOptionText,
  defaultValue,
  fieldName,
  start,
  end,
  onChange,
  placeholder,
  isInvalid,
  dataTestSubj,
  isClearable = true,
  prepend,
  serviceName
}) {
  var _data$terms;
  let defaultOption;
  if (defaultValue) {
    defaultOption = {
      label: defaultValue,
      value: defaultValue
    };
  }
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(defaultOption ? [defaultOption] : []);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/suggestions', {
      params: {
        query: {
          fieldName,
          fieldValue: searchValue,
          start,
          end,
          serviceName
        }
      }
    });
  }, [fieldName, searchValue, start, end, serviceName], {
    preservePreviousData: false
  });
  const handleChange = (0, _react.useCallback)(changedOptions => {
    setSelectedOptions(changedOptions);
    if (changedOptions.length === 0) {
      onChange('');
    }
    if (changedOptions.length === 1) {
      onChange(changedOptions[0].value ? changedOptions[0].value.trim() : changedOptions[0].value);
    }
  }, [onChange]);
  const handleCreateOption = (0, _react.useCallback)(value => {
    handleChange([{
      label: value,
      value
    }]);
  }, [handleChange]);
  const terms = (_data$terms = data === null || data === void 0 ? void 0 : data.terms) !== null && _data$terms !== void 0 ? _data$terms : [];
  const options = [...(customOptions ? customOptions : []), ...terms.map(name => {
    return {
      label: name,
      value: name
    };
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    customOptionText: customOptionText,
    isClearable: isClearable,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    onChange: handleChange,
    onSearchChange: (0, _lodash.throttle)(setSearchValue, 500),
    options: options,
    placeholder: placeholder,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    isInvalid: isInvalid,
    style: {
      minWidth: '256px'
    },
    onCreateOption: handleCreateOption,
    "data-test-subj": dataTestSubj,
    prepend: prepend
  });
}