"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CauseStacktrace = CauseStacktrace;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Accordion = (0, _common.euiStyled)(_eui.EuiAccordion)`
  border-top: ${({
  theme
}) => theme.eui.euiBorderThin};
  margin-top: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const CausedByContainer = (0, _common.euiStyled)('h5')`
  padding: ${({
  theme
}) => theme.eui.euiSizeS} 0;
`;
const CausedByHeading = (0, _common.euiStyled)('span')`
  color: ${({
  theme
}) => theme.eui.euiTextSubduedColor};
  display: block;
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  font-weight: ${({
  theme
}) => theme.eui.euiFontWeightBold};
  text-transform: uppercase;
`;
const FramesContainer = (0, _common.euiStyled)('div')`
  padding-left: ${({
  theme
}) => theme.eui.euiSizeM};
`;
function CausedBy({
  message
}) {
  return /*#__PURE__*/_react.default.createElement(CausedByContainer, null, /*#__PURE__*/_react.default.createElement(CausedByHeading, null, _i18n.i18n.translate('xpack.apm.stacktraceTab.causedByFramesToogleButtonLabel', {
    defaultMessage: 'Caused By'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, message)));
}
function CauseStacktrace({
  codeLanguage,
  id,
  message = '…',
  stackframes = []
}) {
  if (stackframes.length === 0) {
    return /*#__PURE__*/_react.default.createElement(CausedBy, {
      message: message
    });
  }
  return /*#__PURE__*/_react.default.createElement(Accordion, {
    buttonContent: /*#__PURE__*/_react.default.createElement(CausedBy, {
      message: message
    }),
    id: id
  }, /*#__PURE__*/_react.default.createElement(FramesContainer, null, /*#__PURE__*/_react.default.createElement(_.Stacktrace, {
    stackframes: stackframes,
    codeLanguage: codeLanguage
  })));
}