"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpanLinksTabContent = getSpanLinksTabContent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
var _technical_preview_badge = require("../technical_preview_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSpanLinksTabContent({
  spanLinksCount,
  traceId,
  spanId,
  processorEvent
}) {
  if (!spanLinksCount.linkedChildren && !spanLinksCount.linkedParents) {
    return undefined;
  }
  return {
    id: 'span_links',
    'data-test-subj': 'spanLinksTab',
    prepend: /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
      icon: "beaker"
    }),
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.propertiesTable.tabs.spanLinks', {
      defaultMessage: 'Span links'
    })),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued"
    }, spanLinksCount.linkedChildren + spanLinksCount.linkedParents),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_.SpanLinks, {
      spanLinksCount: spanLinksCount,
      traceId: traceId,
      spanId: spanId,
      processorEvent: processorEvent
    }))
  };
}