"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpanIcon = getSpanIcon;
exports.spanTypeIcons = void 0;
var _maybe = require("../../../../common/utils/maybe");
var _aws = _interopRequireDefault(require("./icons/aws.svg"));
var _cassandra = _interopRequireDefault(require("./icons/cassandra.svg"));
var _database = _interopRequireDefault(require("./icons/database.svg"));
var _default = _interopRequireDefault(require("./icons/default.svg"));
var _documents = _interopRequireDefault(require("./icons/documents.svg"));
var _elasticsearch = _interopRequireDefault(require("./icons/elasticsearch.svg"));
var _globe = _interopRequireDefault(require("./icons/globe.svg"));
var _graphql = _interopRequireDefault(require("./icons/graphql.svg"));
var _grpc = _interopRequireDefault(require("./icons/grpc.svg"));
var _handlebars = _interopRequireDefault(require("./icons/handlebars.svg"));
var _kafka = _interopRequireDefault(require("./icons/kafka.svg"));
var _mongodb = _interopRequireDefault(require("./icons/mongodb.svg"));
var _mysql = _interopRequireDefault(require("./icons/mysql.svg"));
var _postgresql = _interopRequireDefault(require("./icons/postgresql.svg"));
var _redis = _interopRequireDefault(require("./icons/redis.svg"));
var _websocket = _interopRequireDefault(require("./icons/websocket.svg"));
var _java = _interopRequireDefault(require("../agent_icon/icons/java.svg"));
var _dynamo_db = _interopRequireDefault(require("./icons/dynamo_db.svg"));
var _s = _interopRequireDefault(require("./icons/s3.svg"));
var _sns = _interopRequireDefault(require("./icons/sns.svg"));
var _sqs = _interopRequireDefault(require("./icons/sqs.svg"));
var _cosmos_db = _interopRequireDefault(require("./icons/cosmos_db.svg"));
var _blob_storage = _interopRequireDefault(require("./icons/blob_storage.svg"));
var _file_share_storage = _interopRequireDefault(require("./icons/file_share_storage.svg"));
var _service_bus = _interopRequireDefault(require("./icons/service_bus.svg"));
var _storage_queue = _interopRequireDefault(require("./icons/storage_queue.svg"));
var _table_storage = _interopRequireDefault(require("./icons/table_storage.svg"));
var _ldap = _interopRequireDefault(require("./icons/ldap.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultSpanTypeIcons = {
  cache: _database.default,
  db: _database.default,
  ext: _globe.default,
  external: _globe.default,
  messaging: _documents.default,
  resource: _globe.default
};
const spanTypeIcons = {
  aws: {
    servicename: _aws.default
  },
  cache: {
    redis: _redis.default
  },
  db: {
    cassandra: _cassandra.default,
    cosmosdb: _cosmos_db.default,
    dynamodb: _dynamo_db.default,
    elasticsearch: _elasticsearch.default,
    mongodb: _mongodb.default,
    mysql: _mysql.default,
    postgresql: _postgresql.default,
    redis: _redis.default
  },
  external: {
    graphql: _graphql.default,
    grpc: _grpc.default,
    websocket: _websocket.default,
    ldap: _ldap.default
  },
  messaging: {
    azurequeue: _storage_queue.default,
    azureservicebus: _service_bus.default,
    jms: _java.default,
    kafka: _kafka.default,
    sns: _sns.default,
    sqs: _sqs.default
  },
  storage: {
    azureblob: _blob_storage.default,
    azurefile: _file_share_storage.default,
    azuretable: _table_storage.default,
    s3: _s.default
  },
  template: {
    handlebars: _handlebars.default
  }
};
exports.spanTypeIcons = spanTypeIcons;
function getSpanIcon(type, subtype) {
  if (!type) {
    return _default.default;
  }
  const types = (0, _maybe.maybe)(spanTypeIcons[type]);
  if (subtype && types && subtype in types) {
    return types[subtype];
  }
  return defaultSpanTypeIcons[type] || _default.default;
}