"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = SearchBar;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../common/agent_name");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _time_comparison = require("../time_comparison");
var _transaction_type_select = require("../transaction_type_select");
var _unified_search_bar = require("../unified_search_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchBar({
  hidden = false,
  showUnifiedSearchBar = true,
  showTimeComparison = false,
  showTransactionTypeSelector = false,
  searchBarPlaceholder,
  searchBarBoolFilter
}) {
  const {
    agentName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isMobileAgent = (0, _agent_name.isMobileAgentName)(agentName);
  const {
    isSmall,
    isMedium,
    isLarge,
    isXl,
    isXXL,
    isXXXL
  } = (0, _use_breakpoints.useBreakpoints)();
  if (hidden) {
    return null;
  }
  const searchBarDirection = isXXXL || !isXl && !showTimeComparison ? 'row' : 'column';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: searchBarDirection
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isLarge ? 'columnReverse' : 'row',
    gutterSize: "s",
    responsive: false
  }, showTransactionTypeSelector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_type_select.TransactionTypeSelect, null)), showUnifiedSearchBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    placeholder: searchBarPlaceholder,
    boolFilter: searchBarBoolFilter
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: showTimeComparison && !isXXXL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isSmall || isMedium || isLarge ? 'columnReverse' : 'row',
    justifyContent: isXXL ? 'flexEnd' : undefined,
    gutterSize: "s",
    responsive: false
  }, showTimeComparison && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isXXXL,
    style: {
      minWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_time_comparison.TimeComparison, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: isMobileAgent ? 's' : 'm'
  }));
}