"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSectionsFromFields = exports.filterSectionsByTerm = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCLUDED_FIELDS = ['error.exception.stacktrace', 'span.stacktrace'];
const getSectionsFromFields = fields => {
  const rows = Object.keys(fields).filter(field => !EXCLUDED_FIELDS.some(excluded => field.startsWith(excluded))).sort().map(field => {
    return {
      section: field.split('.')[0],
      field,
      value: fields[field]
    };
  });
  const sections = Object.values((0, _lodash.groupBy)(rows, 'section')).map(rowsForSection => {
    const first = rowsForSection[0];
    const section = {
      key: first.section,
      label: first.section.toLowerCase(),
      properties: rowsForSection.map(row => ({
        field: row.field,
        value: row.value
      }))
    };
    return section;
  });
  const [labelSections, otherSections] = (0, _lodash.partition)(sections, section => section.key === 'labels' || section.key === 'numeric_labels');
  return [...labelSections, ...otherSections];
};
exports.getSectionsFromFields = getSectionsFromFields;
const filterSectionsByTerm = (sections, searchTerm) => {
  if (!searchTerm) {
    return sections;
  }
  return sections.map(section => {
    const {
      properties = []
    } = section;
    const filteredProps = properties.filter(({
      field,
      value
    }) => {
      return field.toLowerCase().includes(searchTerm) || value.some(val => String(val).toLowerCase().includes(searchTerm));
    });
    return {
      ...section,
      properties: filteredProps
    };
  }).filter(({
    properties
  }) => !(0, _lodash.isEmpty)(properties));
};
exports.filterSectionsByTerm = filterSectionsByTerm;