"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverErrorLink = DiscoverErrorLink;
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../../common/es_fields/apm");
var _discover_link = require("./discover_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDiscoverQuery(error, kuery) {
  const serviceName = error.service.name;
  const groupId = error.error.grouping_key;
  let query = `${_apm.SERVICE_NAME}:"${serviceName}" AND ${_apm.ERROR_GROUP_ID}:"${groupId}"`;
  if (kuery) {
    query += ` AND ${kuery}`;
  }
  return {
    _a: {
      interval: 'auto',
      query: {
        language: 'kuery',
        query
      },
      sort: {
        '@timestamp': 'desc'
      }
    }
  };
}
function DiscoverErrorLink({
  error,
  kuery,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_discover_link.DiscoverLink, {
    query: getDiscoverQuery(error, kuery),
    children: children
  });
}