"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyLink = DependencyLink;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _style = require("../../../utils/style");
var _span_icon = require("../span_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledLink = (0, _common.euiStyled)(_eui.EuiLink)`${(0, _style.truncate)('100%')};`;
function DependencyLink({
  query,
  subtype,
  type,
  onClick
}) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  return /*#__PURE__*/_react.default.createElement(StyledLink, {
    href: link('/dependencies/overview', {
      query
    }),
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_span_icon.SpanIcon, {
    type: type,
    subtype: subtype
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, query.dependencyName))));
}