"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetailLink = TransactionDetailLink;
exports.txGroupsDroppedBucketName = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _pick_keys = require("../../../../../../common/utils/pick_keys");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
var _style = require("../../../../../utils/style");
var _popover_tooltip = require("../../../popover_tooltip");
var _get_comparison_enabled = require("../../../time_comparison/get_comparison_enabled");
var _truncate_with_tooltip = require("../../../truncate_with_tooltip");
var _apm_link = require("../apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const txGroupsDroppedBucketName = '_other';
exports.txGroupsDroppedBucketName = txGroupsDroppedBucketName;
const persistedFilters = ['transactionResult', 'serviceVersion'];
function TransactionDetailLink({
  serviceName,
  traceId,
  transactionId,
  transactionName,
  transactionType,
  latencyAggregationType,
  environment,
  comparisonEnabled,
  offset = '1d',
  overflowCount = 0,
  ...rest
}) {
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const defaultComparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled: comparisonEnabled
  });
  const location = (0, _reactRouterDom.useLocation)();
  const href = (0, _apm_link.getLegacyApmHref)({
    basePath: core.http.basePath,
    path: `/services/${serviceName}/transactions/view`,
    query: {
      traceId,
      transactionId,
      transactionName,
      transactionType,
      comparisonEnabled: defaultComparisonEnabled,
      offset,
      ...(0, _pick_keys.pickKeys)(urlParams, ...persistedFilters),
      ...(0, _lodash.pickBy)({
        latencyAggregationType,
        environment
      }, _lodash.identity)
    },
    search: location.search
  });
  if (transactionName !== txGroupsDroppedBucketName) {
    return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      text: transactionName,
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "apmTransactionDetailLinkLink",
        href: href
      }, rest))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      fontStyle: 'italic'
    }
  }, _i18n.i18n.translate('xpack.apm.transactionDetail.remainingServices', {
    defaultMessage: 'Remaining Transactions'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
    ariaLabel: _i18n.i18n.translate('xpack.apm.transactionDetail.tooltip', {
      defaultMessage: 'Max transaction groups reached tooltip'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: `${_style.unit * 28}px`
    },
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The APM server has reached the maximum capacity that it can currently handle in terms of showing individual transaction groups. Please consider scaling-up your APM server capacity and/or tuning the application instrumentation in order to view all of the data.",
    id: "xpack.apm.transactionDetail.maxGroup.message"
  })))));
}