"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = LicensePrompt;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LicensePrompt({
  text,
  showBetaBadge = false
}) {
  const licensePageUrl = (0, _use_kibana_url.useKibanaUrl)('/app/management/stack/license_management');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: showBetaBadge ? undefined : 'plain',
    paddingSize: "l",
    betaBadgeProps: showBetaBadge ? {
      label: _i18n.i18n.translate('xpack.apm.license.betaBadge', {
        defaultMessage: 'Beta'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.apm.license.betaTooltipMessage', {
        defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, please open an issue or visit our discussion forum.'
      })
    } : undefined,
    title: _i18n.i18n.translate('xpack.apm.license.title', {
      defaultMessage: 'Start free 30-day trial'
    }),
    titleElement: "h2",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, text),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmLicensePromptStartTrialButton",
      fill: true,
      href: licensePageUrl
    }, _i18n.i18n.translate('xpack.apm.license.button', {
      defaultMessage: 'Start trial'
    }))
  });
}