"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalLines = VerticalLines;
var _react = _interopRequireDefault(require("react"));
var _use_theme = require("../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function VerticalLines({
  topTraceDuration,
  plotValues,
  marks = []
}) {
  const {
    width,
    height,
    margins,
    tickValues,
    xScale
  } = plotValues;
  const markTimes = marks.filter(mark => mark.verticalLine).map(({
    offset
  }) => offset);
  const theme = (0, _use_theme.useTheme)();
  const tickPositions = tickValues.reduce((positions, tick) => {
    const position = xScale(tick);
    return Number.isFinite(position) ? [...positions, position] : positions;
  }, []);
  const markPositions = markTimes.reduce((positions, mark) => {
    const position = xScale(mark);
    return Number.isFinite(position) ? [...positions, position] : positions;
  }, []);
  const topTraceDurationPosition = topTraceDuration > 0 ? xScale(topTraceDuration) : NaN;
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    height: height + margins.top,
    style: {
      position: 'absolute',
      top: 0,
      left: 0
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: `translate(0 ${margins.top})`
  }, tickPositions.map(position => /*#__PURE__*/_react.default.createElement("line", {
    key: `tick-${position}`,
    x1: position,
    x2: position,
    y1: 0,
    y2: height,
    stroke: theme.eui.euiColorLightestShade
  })), markPositions.map(position => /*#__PURE__*/_react.default.createElement("line", {
    key: `mark-${position}`,
    x1: position,
    x2: position,
    y1: 0,
    y2: height,
    stroke: theme.eui.euiColorMediumShade
  })), Number.isFinite(topTraceDurationPosition) && /*#__PURE__*/_react.default.createElement("line", {
    key: "topTrace",
    x1: topTraceDurationPosition,
    x2: topTraceDurationPosition,
    y1: 0,
    y2: height,
    stroke: theme.eui.euiColorMediumShade
  })));
}