"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timeline = Timeline;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _plot_utils = require("./plot_utils");
var _timeline_axis = require("./timeline_axis");
var _vertical_lines = require("./vertical_lines");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimeLineContainer({
  width,
  xMin,
  xMax,
  height,
  marks,
  margins
}) {
  if (xMax == null || !width) {
    return null;
  }
  const plotValues = (0, _plot_utils.getPlotValues)({
    width,
    xMin,
    xMax,
    height,
    margins
  });
  const topTraceDuration = xMax - (xMin !== null && xMin !== void 0 ? xMin : 0);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_timeline_axis.TimelineAxis, {
    plotValues: plotValues,
    marks: marks,
    topTraceDuration: topTraceDuration
  }), /*#__PURE__*/_react.default.createElement(_vertical_lines.VerticalLines, {
    plotValues: plotValues,
    marks: marks,
    topTraceDuration: topTraceDuration
  }));
}
function Timeline(props) {
  const [width, setWidth] = (0, _react.useState)(0);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: size => setWidth(size.width)
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%',
      height: '100%'
    },
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement(TimeLineContainer, (0, _extends2.default)({}, props, {
    width: width
  }))));
}