"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatencyChart = LatencyChart;
exports.filterNil = filterNil;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _get_comparison_options = require("../../time_comparison/get_comparison_options");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _formatters = require("../../../../../common/utils/formatters");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_transaction_latency_chart_fetcher = require("../../../../hooks/use_transaction_latency_chart_fetcher");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _helper = require("../transaction_charts/helper");
var _ml_header = require("../transaction_charts/ml_header");
var urlHelpers = _interopRequireWildcard(require("../../links/url_helpers"));
var _get_comparison_chart_theme = require("../../time_comparison/get_comparison_chart_theme");
var _use_environments_context = require("../../../../context/environments_context/use_environments_context");
var _apm_ml_detectors = require("../../../../../common/anomaly_detection/apm_ml_detectors");
var _use_preferred_service_anomaly_timeseries = require("../../../../hooks/use_preferred_service_anomaly_timeseries");
var _use_apm_params = require("../../../../hooks/use_apm_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  value: _latency_aggregation_types.LatencyAggregationType.avg,
  text: 'Average'
}, {
  value: _latency_aggregation_types.LatencyAggregationType.p95,
  text: '95th percentile'
}, {
  value: _latency_aggregation_types.LatencyAggregationType.p99,
  text: '99th percentile'
}];
function filterNil(value) {
  return value != null;
}
function LatencyChart({
  height,
  kuery
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const license = (0, _use_license_context.useLicenseContext)();
  const {
    query: {
      comparisonEnabled,
      latencyAggregationType,
      offset
    },
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/overview', '/services/{serviceName}/transactions', '/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions', '/mobile-services/{serviceName}/transactions/view');
  const {
    environment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const {
    latencyChartsData,
    latencyChartsStatus
  } = (0, _use_transaction_latency_chart_fetcher.useTransactionLatencyChartsFetcher)({
    kuery,
    environment,
    transactionName: 'transactionName' in query ? query.transactionName : null,
    latencyAggregationType: (0, _latency_aggregation_types.getLatencyAggregationType)(latencyAggregationType)
  });
  const {
    currentPeriod,
    previousPeriod
  } = latencyChartsData;
  const preferredAnomalyTimeseries = (0, _use_preferred_service_anomaly_timeseries.usePreferredServiceAnomalyTimeseries)(_apm_ml_detectors.ApmMlDetectorType.txLatency);
  const anomalyTimeseriesColor = previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.color;
  const timeseries = [currentPeriod, comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriod : undefined].filter(filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseries);
  const latencyFormatter = (0, _formatters.getDurationFormatter)(latencyMaxY);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.latencyChartTitle', {
    defaultMessage: 'Latency'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmLatencyChartSelect",
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.apm.serviceOverview.latencyChartTitle.prepend', {
      defaultMessage: 'Metric'
    }),
    options: options,
    value: latencyAggregationType,
    onChange: nextOption => {
      urlHelpers.push(history, {
        query: {
          latencyAggregationType: nextOption.target.value
        }
      });
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ml_header.MLHeader, {
    hasValidMlLicense: license === null || license === void 0 ? void 0 : license.getFeature('ml').isAvailable,
    mlJobId: preferredAnomalyTimeseries === null || preferredAnomalyTimeseries === void 0 ? void 0 : preferredAnomalyTimeseries.jobId
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    height: height,
    fetchStatus: latencyChartsStatus,
    id: "latencyChart",
    customTheme: comparisonChartTheme,
    timeseries: timeseries,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    anomalyTimeseries: preferredAnomalyTimeseries ? {
      ...preferredAnomalyTimeseries,
      color: anomalyTimeseriesColor
    } : undefined
  })));
}