"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationDistributionChartWithScrubber = DurationDistributionChartWithScrubber;
exports.MIN_TAB_TITLE_HEIGHT = void 0;
exports.getFormattedSelection = getFormattedSelection;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _chart_title_tool_tip = require("../../../app/correlations/chart_title_tool_tip");
var _formatters = require("../../../../../common/utils/formatters");
var _duration_distribution_chart = require("../duration_distribution_chart");
var _total_doc_count_label = require("../duration_distribution_chart/total_doc_count_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Format the selected latency range for the "Clear selection" badge.
// If the two values share the same unit, it will only displayed once.
// For example: 12 - 23 ms / 12 ms - 3 s
function getFormattedSelection(selection) {
  const from = (0, _formatters.getDurationFormatter)(selection[0])(selection[0]);
  const to = (0, _formatters.getDurationFormatter)(selection[1])(selection[1]);
  return `${from.unit === to.unit ? from.value : from.formatted} - ${to.formatted}`;
}

// Enforce min height so it's consistent across all tabs on the same level
// to prevent "flickering" behavior
const MIN_TAB_TITLE_HEIGHT = 56;
exports.MIN_TAB_TITLE_HEIGHT = MIN_TAB_TITLE_HEIGHT;
function DurationDistributionChartWithScrubber({
  onClearSelection,
  onChartSelection,
  selection,
  status,
  markerCurrentEvent,
  percentileThresholdValue,
  chartData,
  totalDocCount,
  hasData,
  eventType
}) {
  const emptySelectionText = _i18n.i18n.translate('xpack.apm.durationDistributionChartWithScrubber.emptySelectionText', {
    defaultMessage: 'Click and drag to select a range'
  });
  const clearSelectionAriaLabel = _i18n.i18n.translate('xpack.apm.durationDistributionChartWithScrubber.clearSelectionAriaLabel', {
    defaultMessage: 'Clear selection'
  });
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const onTrackedChartSelection = brushEvent => {
    onChartSelection(brushEvent);
    // metric name is transaction_x for bwc
    trackApmEvent({
      metric: 'transaction_distribution_chart_selection'
    });
  };
  const onTrackedClearSelection = () => {
    onClearSelection();
    // metric name is transaction_x for bwc
    trackApmEvent({
      metric: 'transaction_distribution_chart_clear_selection'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: MIN_TAB_TITLE_HEIGHT
    },
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "apmDurationDistributionChartWithScrubberTitle"
  }, _i18n.i18n.translate('xpack.apm.durationDistributionChartWithScrubber.panelTitle', {
    defaultMessage: 'Latency distribution'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_title_tool_tip.ChartTitleToolTip, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_total_doc_count_label.TotalDocCountLabel, {
    eventType: eventType,
    totalDocCount: totalDocCount
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "xs"
  }, selection ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "cross",
    iconSide: "left",
    onClick: onTrackedClearSelection,
    onClickAriaLabel: clearSelectionAriaLabel,
    iconOnClick: onTrackedClearSelection,
    iconOnClickAriaLabel: clearSelectionAriaLabel,
    "data-test-sub": "apmDurationDistributionChartWithScrubberTitleClearSelectionBadge"
  }, _i18n.i18n.translate('xpack.apm.durationDistributionChartWithScrubber.selectionText', {
    defaultMessage: `Selection: {formattedSelection}`,
    values: {
      formattedSelection: getFormattedSelection(selection)
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle",
    title: emptySelectionText,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, emptySelectionText)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_duration_distribution_chart.DurationDistributionChart, {
    data: chartData,
    markerCurrentEvent: markerCurrentEvent,
    markerValue: percentileThresholdValue !== null && percentileThresholdValue !== void 0 ? percentileThresholdValue : 0,
    onChartSelection: onTrackedChartSelection,
    hasData: hasData,
    selection: selection,
    status: status,
    eventType: eventType
  }));
}