"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregatedTransactionsBadge = AggregatedTransactionsBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AggregatedTransactionsBadge() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.aggregatedTransactions.fallback.tooltip', {
      defaultMessage: `This page is using transaction event data as no metric events were found in the current time range, or a filter has been applied based on fields that are not available in metric event documents.`
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "iInCircle",
    color: "hollow"
  }, _i18n.i18n.translate('xpack.apm.aggregatedTransactions.fallback.badge', {
    defaultMessage: `Based on sampled transactions`
  }))));
}