"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrackPageview = TrackPageview;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _public = require("@kbn/observability-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TrackPageview({
  children
}) {
  const routePath = (0, _typedReactRouterConfig.useRoutePath)();
  (0, _public.useTrackPageview)({
    app: 'apm',
    path: routePath
  }, [routePath]);
  (0, _public.useTrackPageview)({
    app: 'apm',
    path: routePath,
    delay: 15000
  }, [routePath]);
  return children;
}