"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storageExplorer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var t = _interopRequireWildcard(require("io-ts"));
var _storage_explorer = require("../../app/storage_explorer");
var _beta_badge = require("../../shared/beta_badge");
var _apm_main_template = require("../templates/apm_main_template");
var _breadcrumb = require("../../app/breadcrumb");
var _storage_explorer_types = require("../../../../common/storage_explorer_types");
var _get_storage_explorer_links = require("../../app/storage_explorer/get_storage_explorer_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storageExplorer = {
  '/storage-explorer': {
    element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
      title: _i18n.i18n.translate('xpack.apm.views.storageExplorer.title', {
        defaultMessage: 'Storage explorer'
      }),
      href: "/storage-explorer"
    }, /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
      pageHeader: {
        alignItems: 'center',
        pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexStart",
          gutterSize: "s",
          alignItems: "baseline"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "l"
        }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.apm.views.storageExplorer.title', {
          defaultMessage: 'Storage explorer'
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, null))),
        rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmGiveFeedbackLink",
          href: (0, _get_storage_explorer_links.getStorageExplorerFeedbackHref)(),
          target: "_blank"
        }, _i18n.i18n.translate('xpack.apm.views.storageExplorer.giveFeedback', {
          defaultMessage: 'Give feedback'
        }))]
      }
    }, /*#__PURE__*/_react.default.createElement(_storage_explorer.StorageExplorer, null))),
    params: t.type({
      query: _storage_explorer_types.indexLifecyclePhaseRt
    }),
    defaults: {
      query: {
        indexLifecyclePhase: _storage_explorer_types.IndexLifecyclePhaseSelectOption.All
      }
    }
  }
};
exports.storageExplorer = storageExplorer;