"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.home = exports.ServiceMapTitle = exports.ServiceInventoryTitle = exports.DependenciesOperationsTitle = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _comparison_rt = require("../../../../common/comparison_rt");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _environment_rt = require("../../../../common/environment_rt");
var _trace_explorer = require("../../../../common/trace_explorer");
var _time_range_metadata_context = require("../../../context/time_range_metadata/time_range_metadata_context");
var _breadcrumb = require("../../app/breadcrumb");
var _service_inventory = require("../../app/service_inventory");
var _service_map = require("../../app/service_map");
var _top_traces_overview = require("../../app/top_traces_overview");
var _trace_explorer2 = require("../../app/trace_explorer");
var _trace_explorer_aggregated_critical_path = require("../../app/trace_explorer/trace_explorer_aggregated_critical_path");
var _trace_explorer_waterfall = require("../../app/trace_explorer/trace_explorer_waterfall");
var _trace_overview = require("../../app/trace_overview");
var _transaction_tabs = require("../../app/transaction_details/waterfall_with_summary/transaction_tabs");
var _redirect_to = require("../redirect_to");
var _service_group_template = require("../templates/service_group_template");
var _dependencies = require("./dependencies");
var _legacy_backends = require("./legacy_backends");
var _storage_explorer = require("./storage_explorer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function serviceGroupPage({
  path,
  element,
  title,
  serviceGroupContextTab
}) {
  return {
    [path]: {
      element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
        title: title,
        href: path
      }, /*#__PURE__*/_react.default.createElement(_service_group_template.ServiceGroupTemplate, {
        pageTitle: title,
        serviceGroupContextTab: serviceGroupContextTab
      }, element)),
      params: t.type({
        query: t.type({
          serviceGroup: t.string
        })
      }),
      defaults: {
        query: {
          serviceGroup: ''
        }
      }
    }
  };
}
const ServiceInventoryTitle = _i18n.i18n.translate('xpack.apm.views.serviceInventory.title', {
  defaultMessage: 'Services'
});
exports.ServiceInventoryTitle = ServiceInventoryTitle;
const ServiceMapTitle = _i18n.i18n.translate('xpack.apm.views.serviceMap.title', {
  defaultMessage: 'Service Map'
});
exports.ServiceMapTitle = ServiceMapTitle;
const DependenciesOperationsTitle = _i18n.i18n.translate('xpack.apm.views.dependenciesOperations.title', {
  defaultMessage: 'Operations'
});
exports.DependenciesOperationsTitle = DependenciesOperationsTitle;
const home = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.ApmTimeRangeMetadataContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    params: t.type({
      query: t.intersection([_environment_rt.environmentRt, t.type({
        rangeFrom: t.string,
        rangeTo: t.string,
        kuery: t.string,
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), t.partial({
        refreshPaused: t.union([t.literal('true'), t.literal('false')]),
        refreshInterval: t.string,
        page: _ioTsUtils.toNumberRt,
        pageSize: _ioTsUtils.toNumberRt,
        sortField: t.string,
        sortDirection: t.union([t.literal('asc'), t.literal('desc')])
      }), _comparison_rt.offsetRt])
    }),
    defaults: {
      query: {
        environment: _environment_filter_values.ENVIRONMENT_ALL.value,
        kuery: ''
      }
    },
    children: {
      ...serviceGroupPage({
        path: '/services',
        title: ServiceInventoryTitle,
        element: /*#__PURE__*/_react.default.createElement(_service_inventory.ServiceInventory, null),
        serviceGroupContextTab: 'service-inventory'
      }),
      ...serviceGroupPage({
        path: '/service-map',
        title: ServiceMapTitle,
        element: /*#__PURE__*/_react.default.createElement(_service_map.ServiceMapHome, null),
        serviceGroupContextTab: 'service-map'
      }),
      '/traces': {
        element: /*#__PURE__*/_react.default.createElement(_trace_overview.TraceOverview, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
        children: {
          '/traces/explorer': {
            element: /*#__PURE__*/_react.default.createElement(_trace_explorer2.TraceExplorer, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
            children: {
              '/traces/explorer/waterfall': {
                element: /*#__PURE__*/_react.default.createElement(_trace_explorer_waterfall.TraceExplorerWaterfall, null),
                params: t.type({
                  query: t.intersection([t.type({
                    traceId: t.string,
                    transactionId: t.string,
                    waterfallItemId: t.string,
                    detailTab: t.union([t.literal(_transaction_tabs.TransactionTab.timeline), t.literal(_transaction_tabs.TransactionTab.metadata), t.literal(_transaction_tabs.TransactionTab.logs)])
                  }), t.partial({
                    flyoutDetailTab: t.string
                  })])
                }),
                defaults: {
                  query: {
                    waterfallItemId: '',
                    traceId: '',
                    transactionId: '',
                    detailTab: _transaction_tabs.TransactionTab.timeline
                  }
                }
              },
              '/traces/explorer/critical_path': {
                element: /*#__PURE__*/_react.default.createElement(_trace_explorer_aggregated_critical_path.TraceExplorerAggregatedCriticalPath, null)
              },
              '/traces/explorer': {
                element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
                  pathname: "/traces/explorer/waterfall"
                })
              }
            },
            params: t.type({
              query: t.type({
                query: t.string,
                type: t.union([t.literal(_trace_explorer.TraceSearchType.kql), t.literal(_trace_explorer.TraceSearchType.eql)]),
                showCriticalPath: _ioTsUtils.toBooleanRt
              })
            }),
            defaults: {
              query: {
                query: '',
                type: _trace_explorer.TraceSearchType.kql,
                showCriticalPath: ''
              }
            }
          },
          '/traces': {
            element: /*#__PURE__*/_react.default.createElement(_top_traces_overview.TopTracesOverview, null)
          }
        }
      },
      ..._dependencies.dependencies,
      ..._legacy_backends.legacyBackends,
      ..._storage_explorer.storageExplorer,
      '/': {
        element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
          pathname: "/services"
        })
      }
    }
  }
};
exports.home = home;