"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionSetupLink = AnomalyDetectionSetupLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_anomaly_detection_setup_state = require("../../../../../common/anomaly_detection/get_anomaly_detection_setup_state");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_anomaly_detection_jobs_context = require("../../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_theme = require("../../../../hooks/use_theme");
var _apm_link = require("../../../shared/links/apm/apm_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnomalyDetectionSetupLink() {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const environment = 'environment' in query && query.environment || _environment_filter_values.ENVIRONMENT_ALL.value;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    basePath
  } = core.http;
  const theme = (0, _use_theme.useTheme)();
  const {
    anomalyDetectionSetupState
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  let tooltipText = '';
  let color = 'text';
  let icon;
  if (anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.Failure) {
    color = 'warning';
    tooltipText = _i18n.i18n.translate('xpack.apm.anomalyDetectionSetup.jobFetchFailureText', {
      defaultMessage: 'Could not determine state of anomaly detection setup.'
    });
    icon = 'machineLearningApp';
  } else if (anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.NoJobs || anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.NoJobsForEnvironment) {
    color = 'warning';
    tooltipText = getNoJobsMessage(anomalyDetectionSetupState, environment);
    icon = 'machineLearningApp';
  } else if (anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.UpgradeableJobs) {
    color = 'success';
    tooltipText = _i18n.i18n.translate('xpack.apm.anomalyDetectionSetup.upgradeableJobsText', {
      defaultMessage: 'Updates available for existing anomaly detection jobs.'
    });
    icon = 'wrench';
  }
  let pre = null;
  if (anomalyDetectionSetupState === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.Loading) {
    pre = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    });
  } else if (icon) {
    pre = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      color: color,
      size: "s"
    });
  }
  const element = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: color,
    href: (0, _apm_link.getLegacyApmHref)({
      basePath,
      path: '/settings/anomaly-detection'
    }),
    style: {
      whiteSpace: 'nowrap'
    },
    "data-test-subj": "apmAnomalyDetectionHeaderLink"
  }, pre, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      marginInlineStart: theme.eui.euiSizeS
    }
  }, ANOMALY_DETECTION_LINK_LABEL));
  const wrappedElement = tooltipText ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: tooltipText
  }, element) : element;
  return wrappedElement;
}
function getNoJobsMessage(state, environment) {
  if (state === _get_anomaly_detection_setup_state.AnomalyDetectionSetupState.NoJobs) {
    return _i18n.i18n.translate('xpack.apm.anomalyDetectionSetup.notEnabledText', {
      defaultMessage: `Anomaly detection is not yet enabled. Click to continue setup.`
    });
  }
  return _i18n.i18n.translate('xpack.apm.anomalyDetectionSetup.notEnabledForEnvironmentText', {
    defaultMessage: `Anomaly detection is not yet enabled for the environment "{currentEnvironment}". Click to continue setup.`,
    values: {
      currentEnvironment: (0, _environment_filter_values.getEnvironmentLabel)(environment)
    }
  });
}
const ANOMALY_DETECTION_LINK_LABEL = _i18n.i18n.translate('xpack.apm.anomalyDetectionSetup.linkLabel', {
  defaultMessage: `Anomaly detection`
});