"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsForm = SettingsForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _form_row_setting = require("./form_row_setting");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FormRow({
  initialSetting,
  vars,
  onChange
}) {
  function getSettingFormRow(row) {
    if (row.type === 'advanced_setting') {
      return /*#__PURE__*/_react.default.createElement(AdvancedOptions, null, row.settings.map(advancedSetting => getSettingFormRow(advancedSetting)));
    }
    const {
      key
    } = row;
    const configEntry = vars === null || vars === void 0 ? void 0 : vars[key];
    // hides a field that doesn't have its key defined in vars.
    // This is most likely to happen when a field is no longer supported in the current package version
    if (!configEntry) {
      return null;
    }
    const {
      value,
      frozen
    } = configEntry;
    const {
      isValid,
      message
    } = (0, _utils.validateSettingValue)(row, value);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: key
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, row.rowTitle),
      description: row.rowDescription
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: row.label,
      isInvalid: !isValid,
      error: isValid ? undefined : message,
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, row.helpText),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, row.labelAppend)
    }, /*#__PURE__*/_react.default.createElement(_form_row_setting.FormRowSetting, {
      row: row,
      onChange: onChange,
      value: value,
      isDisabled: frozen
    }))), row.settings && value && row.settings.map(childSettings => getSettingFormRow(childSettings)));
  }
  return getSettingFormRow(initialSetting);
}
function SettingsForm({
  settingsSection,
  vars,
  onChange
}) {
  const {
    title,
    subtitle,
    settings,
    isPlatinumLicence
  } = settingsSection;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title, " \xA0", isPlatinumLicence && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.platinumBadgeLabel', {
      defaultMessage: 'Platinum'
    }),
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.platinumBadgeTooltipTitle', {
      defaultMessage: 'Platinum license required'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.platinumBadgeTooltipDescription', {
      defaultMessage: 'Configurations are saved but ignored if your Kibana licence is not Platinum.'
    })
  })))), subtitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, subtitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), settings.map(setting => {
    return FormRow({
      initialSetting: setting,
      vars,
      onChange
    });
  }));
}
function AdvancedOptions({
  children
}) {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmAdvancedOptionsAdvancedOptionsButton",
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    onClick: () => {
      setIsOpen(state => !state);
    }
  }, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.advancedOptionsLavel', {
    defaultMessage: 'Advanced options'
  })))))), isOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), children));
}