"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMPolicyForm = APMPolicyForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _agent_authorization_settings = require("./settings_definition/agent_authorization_settings");
var _apm_settings = require("./settings_definition/apm_settings");
var _debug_settings = require("./settings_definition/debug_settings");
var _rum_settings = require("./settings_definition/rum_settings");
var _tail_sampling_settings = require("./settings_definition/tail_sampling_settings");
var _tls_settings = require("./settings_definition/tls_settings");
var _settings_form = require("./settings_form");
var _utils = require("./settings_form/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function APMPolicyForm({
  vars = {},
  updateAPMPolicy
}) {
  var _useKibana$services$d;
  const tailSamplingPoliciesDocsLink = (_useKibana$services$d = (0, _public.useKibana)().services.docLinks) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.links.apm.tailSamplingPolicies;
  const {
    apmSettings,
    rumSettings,
    tlsSettings,
    agentAuthorizationSettings,
    tailSamplingSettings,
    debugSettings
  } = (0, _react.useMemo)(() => {
    return {
      apmSettings: (0, _apm_settings.getApmSettings)(),
      rumSettings: (0, _rum_settings.getRUMSettings)(),
      tlsSettings: (0, _tls_settings.getTLSSettings)(),
      debugSettings: (0, _debug_settings.getDebugSettings)(),
      agentAuthorizationSettings: (0, _agent_authorization_settings.getAgentAuthorizationSettings)(),
      tailSamplingSettings: (0, _tail_sampling_settings.getTailSamplingSettings)(tailSamplingPoliciesDocsLink)
    };
  }, [tailSamplingPoliciesDocsLink]);
  function handleFormChange(key, value) {
    // Merge new key/value with the rest of fields
    const newVars = (0, _utils.mergeNewVars)(vars, key, value);

    // Validate the entire form before sending it to fleet
    const isFormValid = (0, _utils.isSettingsFormValid)(apmSettings, newVars) && (0, _rum_settings.isRUMFormValid)(newVars, rumSettings) && (0, _tls_settings.isTLSFormValid)(newVars, tlsSettings) && (0, _utils.isSettingsFormValid)(agentAuthorizationSettings, newVars) && (0, _tail_sampling_settings.isTailBasedSamplingValid)(newVars, tailSamplingSettings) && (0, _utils.isSettingsFormValid)(debugSettings, newVars);
    updateAPMPolicy(newVars, isFormValid);
  }
  const settingsSections = [{
    id: 'apm',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.apm.settings.title', {
      defaultMessage: 'General'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.apm.settings.subtitle', {
      defaultMessage: 'Settings for the APM integration.'
    }),
    settings: apmSettings
  }, {
    id: 'rum',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.settings.title', {
      defaultMessage: 'Real User Monitoring'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.rum.settings.subtitle', {
      defaultMessage: 'Manage the configuration of the RUM JS agent.'
    }),
    settings: rumSettings
  }, {
    id: 'tls',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.settings.title', {
      defaultMessage: 'TLS Settings'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.settings.subtitle', {
      defaultMessage: 'Settings for TLS certification.'
    }),
    settings: tlsSettings
  }, {
    id: 'agentAuthorization',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.agentAuthorization.settings.title', {
      defaultMessage: 'Agent authorization'
    }),
    settings: agentAuthorizationSettings
  }, ...(vars[_tail_sampling_settings.TAIL_SAMPLING_ENABLED_KEY] ? [{
    id: 'tailSampling',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.settings.title', {
      defaultMessage: 'Tail-based sampling'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.settings.subtitle', {
      defaultMessage: 'Manage tail-based sampling for services and traces.'
    }),
    settings: tailSamplingSettings,
    isPlatinumLicence: true
  }] : []), {
    id: 'debug',
    title: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.settings.title', {
      defaultMessage: 'Debug settings'
    }),
    subtitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.settings.subtitle', {
      defaultMessage: 'Settings for the APM server debug flags'
    }),
    settings: debugSettings
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, settingsSections.map(settingsSection => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: settingsSection.id
    }, /*#__PURE__*/_react.default.createElement(_settings_form.SettingsForm, {
      settingsSection: settingsSection,
      vars: vars,
      onChange: handleFormChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  }));
}